/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectWriter;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class DirCacheTree {
    private static final byte[] NO_NAME = new byte[0];
    private static final DirCacheTree[] NO_CHILDREN = new DirCacheTree[0];
    private static final Comparator<DirCacheTree> TREE_CMP = new Comparator<DirCacheTree>(){

        @Override
        public int compare(DirCacheTree o1, DirCacheTree o2) {
            int cPos;
            byte[] a = o1.encodedName;
            byte[] b = o2.encodedName;
            int aLen = a.length;
            int bLen = b.length;
            for (cPos = 0; cPos < aLen && cPos < bLen; ++cPos) {
                int cmp = (a[cPos] & 0xFF) - (b[cPos] & 0xFF);
                if (cmp == 0) continue;
                return cmp;
            }
            if (aLen == bLen) {
                return 0;
            }
            if (aLen < bLen) {
                return 47 - (b[cPos] & 0xFF);
            }
            return (a[cPos] & 0xFF) - 47;
        }
    };
    private DirCacheTree parent;
    private byte[] encodedName;
    private int entrySpan;
    private ObjectId id;
    private DirCacheTree[] children;
    private int childCnt;

    DirCacheTree() {
        this.encodedName = NO_NAME;
        this.children = NO_CHILDREN;
        this.childCnt = 0;
        this.entrySpan = -1;
    }

    private DirCacheTree(DirCacheTree myParent, byte[] path, int pathOff, int pathLen) {
        this.parent = myParent;
        this.encodedName = new byte[pathLen];
        System.arraycopy(path, pathOff, this.encodedName, 0, pathLen);
        this.children = NO_CHILDREN;
        this.childCnt = 0;
        this.entrySpan = -1;
    }

    DirCacheTree(byte[] in, MutableInteger off, DirCacheTree myParent) {
        this.parent = myParent;
        int ptr = RawParseUtils.next(in, off.value, '\u0000');
        int nameLen = ptr - off.value - 1;
        if (nameLen > 0) {
            this.encodedName = new byte[nameLen];
            System.arraycopy(in, off.value, this.encodedName, 0, nameLen);
        } else {
            this.encodedName = NO_NAME;
        }
        this.entrySpan = RawParseUtils.parseBase10(in, ptr, off);
        int subcnt = RawParseUtils.parseBase10(in, off.value, off);
        off.value = RawParseUtils.next(in, off.value, '\n');
        if (this.entrySpan >= 0) {
            this.id = ObjectId.fromRaw(in, off.value);
            off.value += 20;
        }
        if (subcnt > 0) {
            boolean alreadySorted = true;
            this.children = new DirCacheTree[subcnt];
            for (int i = 0; i < subcnt; ++i) {
                this.children[i] = new DirCacheTree(in, off, this);
                if (!alreadySorted || i <= 0 || TREE_CMP.compare(this.children[i - 1], this.children[i]) <= 0) continue;
                alreadySorted = false;
            }
            if (!alreadySorted) {
                Arrays.sort(this.children, 0, subcnt, TREE_CMP);
            }
        } else {
            this.children = NO_CHILDREN;
        }
        this.childCnt = subcnt;
    }

    void write(byte[] tmp, OutputStream os) throws IOException {
        int ptr = tmp.length;
        tmp[--ptr] = 10;
        ptr = RawParseUtils.formatBase10(tmp, ptr, this.childCnt);
        tmp[--ptr] = 32;
        ptr = RawParseUtils.formatBase10(tmp, ptr, this.isValid() ? this.entrySpan : -1);
        tmp[--ptr] = 0;
        os.write(this.encodedName);
        os.write(tmp, ptr, tmp.length - ptr);
        if (this.isValid()) {
            this.id.copyRawTo(tmp, 0);
            os.write(tmp, 0, 20);
        }
        for (int i = 0; i < this.childCnt; ++i) {
            this.children[i].write(tmp, os);
        }
    }

    public boolean isValid() {
        return this.id != null;
    }

    public int getEntrySpan() {
        return this.entrySpan;
    }

    public int getChildCount() {
        return this.childCnt;
    }

    public DirCacheTree getChild(int i) {
        return this.children[i];
    }

    ObjectId getObjectId() {
        return this.id;
    }

    public String getNameString() {
        ByteBuffer bb = ByteBuffer.wrap(this.encodedName);
        return Constants.CHARSET.decode(bb).toString();
    }

    public String getPathString() {
        StringBuilder r = new StringBuilder();
        this.appendName(r);
        return r.toString();
    }

    ObjectId writeTree(DirCacheEntry[] cache, int cIdx, int pathOffset, ObjectWriter ow) throws UnmergedPathException, IOException {
        if (this.id == null) {
            int endIdx = cIdx + this.entrySpan;
            int size = this.computeSize(cache, cIdx, pathOffset, ow);
            ByteArrayOutputStream out = new ByteArrayOutputStream(size);
            int childIdx = 0;
            int entryIdx = cIdx;
            while (entryIdx < endIdx) {
                DirCacheTree st;
                DirCacheEntry e = cache[entryIdx];
                byte[] ep = e.path;
                if (childIdx < this.childCnt && (st = this.children[childIdx]).contains(ep, pathOffset, ep.length)) {
                    FileMode.TREE.copyTo(out);
                    out.write(32);
                    out.write(st.encodedName);
                    out.write(0);
                    st.id.copyRawTo(out);
                    entryIdx += st.entrySpan;
                    ++childIdx;
                    continue;
                }
                e.getFileMode().copyTo(out);
                out.write(32);
                out.write(ep, pathOffset, ep.length - pathOffset);
                out.write(0);
                out.write(e.idBuffer(), e.idOffset(), 20);
                ++entryIdx;
            }
            this.id = ow.writeCanonicalTree(out.toByteArray());
        }
        return this.id;
    }

    private int computeSize(DirCacheEntry[] cache, int cIdx, int pathOffset, ObjectWriter ow) throws UnmergedPathException, IOException {
        int endIdx = cIdx + this.entrySpan;
        int childIdx = 0;
        int entryIdx = cIdx;
        int size = 0;
        while (entryIdx < endIdx) {
            DirCacheTree st;
            DirCacheEntry e = cache[entryIdx];
            if (e.getStage() != 0) {
                throw new UnmergedPathException(e);
            }
            byte[] ep = e.path;
            if (childIdx < this.childCnt && (st = this.children[childIdx]).contains(ep, pathOffset, ep.length)) {
                int stOffset = pathOffset + st.nameLength() + 1;
                st.writeTree(cache, entryIdx, stOffset, ow);
                size += FileMode.TREE.copyToLength();
                size += st.nameLength();
                size += 22;
                entryIdx += st.entrySpan;
                ++childIdx;
                continue;
            }
            FileMode mode = e.getFileMode();
            if (mode.getObjectType() == -1) {
                throw new IllegalStateException("Entry \"" + e.getPathString() + "\" has incorrect mode set up.");
            }
            size += mode.copyToLength();
            size += ep.length - pathOffset;
            size += 22;
            ++entryIdx;
        }
        return size;
    }

    private void appendName(StringBuilder r) {
        if (this.parent != null) {
            this.parent.appendName(r);
            r.append(this.getNameString());
            r.append('/');
        } else if (this.nameLength() > 0) {
            r.append(this.getNameString());
            r.append('/');
        }
    }

    final int nameLength() {
        return this.encodedName.length;
    }

    final boolean contains(byte[] a, int aOff, int aLen) {
        byte[] e = this.encodedName;
        int eLen = e.length;
        for (int eOff = 0; eOff < eLen && aOff < aLen; ++eOff, ++aOff) {
            if (e[eOff] == a[aOff]) continue;
            return false;
        }
        if (aOff == aLen) {
            return false;
        }
        return a[aOff] == 47;
    }

    void validate(DirCacheEntry[] cache, int cCnt, int cIdx, int pathOff) {
        if (this.entrySpan >= 0) {
            return;
        }
        this.entrySpan = 0;
        if (cCnt == 0) {
            return;
        }
        byte[] firstPath = cache[cIdx].path;
        int stIdx = 0;
        while (cIdx < cCnt) {
            byte[] currPath = cache[cIdx].path;
            if (pathOff > 0 && !DirCacheTree.peq(firstPath, currPath, pathOff)) break;
            DirCacheTree st = stIdx < this.childCnt ? this.children[stIdx] : null;
            int cc = DirCacheTree.namecmp(currPath, pathOff, st);
            if (cc > 0) {
                this.removeChild(stIdx);
                continue;
            }
            if (cc < 0) {
                int p = DirCacheTree.slash(currPath, pathOff);
                if (p < 0) {
                    ++cIdx;
                    ++this.entrySpan;
                    continue;
                }
                st = new DirCacheTree(this, currPath, pathOff, p - pathOff);
                this.insertChild(stIdx, st);
            }
            st.validate(cache, cCnt, cIdx, pathOff + st.nameLength() + 1);
            cIdx += st.entrySpan;
            this.entrySpan += st.entrySpan;
            ++stIdx;
        }
        if (stIdx < this.childCnt) {
            DirCacheTree[] dct = new DirCacheTree[stIdx];
            System.arraycopy(this.children, 0, dct, 0, stIdx);
            this.children = dct;
        }
    }

    private void insertChild(int stIdx, DirCacheTree st) {
        DirCacheTree[] c = this.children;
        if (this.childCnt + 1 <= c.length) {
            if (stIdx < this.childCnt) {
                System.arraycopy(c, stIdx, c, stIdx + 1, this.childCnt - stIdx);
            }
            c[stIdx] = st;
            ++this.childCnt;
            return;
        }
        int n = c.length;
        DirCacheTree[] a = new DirCacheTree[n + 1];
        if (stIdx > 0) {
            System.arraycopy(c, 0, a, 0, stIdx);
        }
        a[stIdx] = st;
        if (stIdx < n) {
            System.arraycopy(c, stIdx, a, stIdx + 1, n - stIdx);
        }
        this.children = a;
        ++this.childCnt;
    }

    private void removeChild(int stIdx) {
        int n;
        if (stIdx < (n = --this.childCnt)) {
            System.arraycopy(this.children, stIdx + 1, this.children, stIdx, n - stIdx);
        }
        this.children[n] = null;
    }

    static boolean peq(byte[] a, byte[] b, int aLen) {
        if (b.length < aLen) {
            return false;
        }
        --aLen;
        while (aLen >= 0) {
            if (a[aLen] != b[aLen]) {
                return false;
            }
            --aLen;
        }
        return true;
    }

    private static int namecmp(byte[] a, int aPos, DirCacheTree ct) {
        int bPos;
        if (ct == null) {
            return -1;
        }
        byte[] b = ct.encodedName;
        int aLen = a.length;
        int bLen = b.length;
        for (bPos = 0; aPos < aLen && bPos < bLen; ++aPos, ++bPos) {
            int cmp = (a[aPos] & 0xFF) - (b[bPos] & 0xFF);
            if (cmp == 0) continue;
            return cmp;
        }
        if (bPos == bLen) {
            return a[aPos] == 47 ? 0 : -1;
        }
        return aLen - bLen;
    }

    private static int slash(byte[] a, int aPos) {
        int aLen = a.length;
        while (aPos < aLen) {
            if (a[aPos] == 47) {
                return aPos;
            }
            ++aPos;
        }
        return -1;
    }
}

