/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.RawParseUtils;

public class RawText
implements Sequence {
    protected final byte[] content;
    protected final IntList lines;
    protected final IntList hashes;

    public RawText(byte[] input) {
        this.content = input;
        this.lines = RawParseUtils.lineMap(this.content, 0, this.content.length);
        this.hashes = this.computeHashes();
    }

    public int size() {
        return this.lines.size() - 2;
    }

    public boolean equals(int i, Sequence other, int j) {
        return RawText.equals(this, i + 1, (RawText)other, j + 1);
    }

    private static boolean equals(RawText a, int ai, RawText b, int bi) {
        int be;
        if (a.hashes.get(ai) != b.hashes.get(bi)) {
            return false;
        }
        int as = a.lines.get(ai);
        int bs = b.lines.get(bi);
        int ae = a.lines.get(ai + 1);
        if (ae - as != (be = b.lines.get(bi + 1)) - bs) {
            return false;
        }
        while (as < ae) {
            if (a.content[as++] == b.content[bs++]) continue;
            return false;
        }
        return true;
    }

    public void writeLine(OutputStream out, int i) throws IOException {
        int start = this.lines.get(i + 1);
        int end = this.lines.get(i + 2);
        if (this.content[end - 1] == 10) {
            --end;
        }
        out.write(this.content, start, end - start);
    }

    public boolean isMissingNewlineAtEnd() {
        int end = this.lines.get(this.lines.size() - 1);
        if (end == 0) {
            return true;
        }
        return this.content[end - 1] != 10;
    }

    private IntList computeHashes() {
        IntList r = new IntList(this.lines.size());
        r.add(0);
        for (int lno = 1; lno < this.lines.size() - 1; ++lno) {
            int ptr = this.lines.get(lno);
            int end = this.lines.get(lno + 1);
            r.add(this.hashLine(this.content, ptr, end));
        }
        r.add(0);
        return r;
    }

    protected int hashLine(byte[] raw, int ptr, int end) {
        int hash = 5381;
        while (ptr < end) {
            hash = hash << 5 ^ raw[ptr] & 0xFF;
            ++ptr;
        }
        return hash;
    }
}

