/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.jgit.util.FS_POSIX_Java5;
import org.eclipse.jgit.util.FS_POSIX_Java6;
import org.eclipse.jgit.util.FS_Win32;
import org.eclipse.jgit.util.FS_Win32_Cygwin;
import org.eclipse.jgit.util.SystemReader;

public abstract class FS {
    public static final FS DETECTED = FS.detect();
    private volatile Holder<File> userHome;
    private volatile Holder<File> gitPrefix;

    public static FS detect() {
        return FS.detect(null);
    }

    public static FS detect(Boolean cygwinUsed) {
        if (FS_Win32.isWin32()) {
            if (cygwinUsed == null) {
                cygwinUsed = FS_Win32_Cygwin.isCygwin();
            }
            if (cygwinUsed.booleanValue()) {
                return new FS_Win32_Cygwin();
            }
            return new FS_Win32();
        }
        if (FS_POSIX_Java6.hasExecute()) {
            return new FS_POSIX_Java6();
        }
        return new FS_POSIX_Java5();
    }

    protected FS() {
    }

    protected FS(FS src) {
        this.userHome = src.userHome;
        this.gitPrefix = src.gitPrefix;
    }

    public abstract FS newInstance();

    public abstract boolean supportsExecute();

    public abstract boolean canExecute(File var1);

    public abstract boolean setExecute(File var1, boolean var2);

    public File resolve(File dir, String name) {
        File abspn = new File(name);
        if (abspn.isAbsolute()) {
            return abspn;
        }
        return new File(dir, name);
    }

    public File userHome() {
        Holder<File> p = this.userHome;
        if (p == null) {
            this.userHome = p = new Holder<File>(this.userHomeImpl());
        }
        return (File)p.value;
    }

    public FS setUserHome(File path) {
        this.userHome = new Holder<File>(path);
        return this;
    }

    public abstract boolean retryFailedLockFileCommit();

    protected File userHomeImpl() {
        String home = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.home");
            }
        });
        if (home == null || home.length() == 0) {
            return null;
        }
        return new File(home).getAbsoluteFile();
    }

    static File searchPath(String path, String ... lookFor) {
        for (String p : path.split(File.pathSeparator)) {
            for (String command : lookFor) {
                File e = new File(p, command);
                if (!e.isFile()) continue;
                return e.getAbsoluteFile();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readPipe(File dir, String[] command, String encoding) {
        block10: {
            try {
                Process p = Runtime.getRuntime().exec(command, null, dir);
                BufferedReader lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), encoding));
                String r = null;
                try {
                    r = lineRead.readLine();
                }
                finally {
                    p.getOutputStream().close();
                    p.getErrorStream().close();
                    lineRead.close();
                }
                while (true) {
                    try {
                        if (p.waitFor() == 0 && r != null && r.length() > 0) {
                            return r;
                        }
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                if (SystemReader.getInstance().getProperty("jgit.fs.debug") == null) break block10;
                System.err.println(e);
            }
        }
        return null;
    }

    public File gitPrefix() {
        Holder<File> p = this.gitPrefix;
        if (p == null) {
            String overrideGitPrefix = SystemReader.getInstance().getProperty("jgit.gitprefix");
            p = overrideGitPrefix != null ? new Holder<File>(new File(overrideGitPrefix)) : new Holder<File>(this.discoverGitPrefix());
            this.gitPrefix = p;
        }
        return (File)p.value;
    }

    protected abstract File discoverGitPrefix();

    public FS setGitPrefix(File path) {
        this.gitPrefix = new Holder<File>(path);
        return this;
    }

    public abstract ProcessBuilder runInShell(String var1, String[] var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Holder<V> {
        final V value;

        Holder(V value) {
            this.value = value;
        }
    }
}

