/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.transport.PackParser;

public abstract class ObjectInserter {
    private final MessageDigest digest = Constants.newMessageDigest();
    private byte[] tempBuffer;

    protected ObjectInserter() {
    }

    protected byte[] buffer() {
        if (this.tempBuffer == null) {
            this.tempBuffer = new byte[8192];
        }
        return this.tempBuffer;
    }

    protected MessageDigest digest() {
        this.digest.reset();
        return this.digest;
    }

    public ObjectId idFor(int type, byte[] data) {
        return this.idFor(type, data, 0, data.length);
    }

    public ObjectId idFor(int type, byte[] data, int off, int len) {
        MessageDigest md = this.digest();
        md.update(Constants.encodedTypeString(type));
        md.update((byte)32);
        md.update(Constants.encodeASCII(len));
        md.update((byte)0);
        md.update(data, off, len);
        return ObjectId.fromRaw(md.digest());
    }

    public ObjectId idFor(int objectType, long length, InputStream in) throws IOException {
        MessageDigest md = this.digest();
        md.update(Constants.encodedTypeString(objectType));
        md.update((byte)32);
        md.update(Constants.encodeASCII(length));
        md.update((byte)0);
        byte[] buf = this.buffer();
        while (length > 0L) {
            int n = in.read(buf, 0, (int)Math.min(length, (long)buf.length));
            if (n < 0) {
                throw new EOFException("Unexpected end of input");
            }
            md.update(buf, 0, n);
            length -= (long)n;
        }
        return ObjectId.fromRaw(md.digest());
    }

    public ObjectId idFor(TreeFormatter formatter) {
        return formatter.computeId(this);
    }

    public final ObjectId insert(TreeFormatter formatter) throws IOException {
        return formatter.insertTo(this);
    }

    public final ObjectId insert(CommitBuilder builder) throws IOException {
        return this.insert(1, builder.build());
    }

    public final ObjectId insert(TagBuilder builder) throws IOException {
        return this.insert(4, builder.build());
    }

    public ObjectId insert(int type, byte[] data) throws IOException {
        return this.insert(type, data, 0, data.length);
    }

    public ObjectId insert(int type, byte[] data, int off, int len) throws IOException {
        return this.insert(type, len, new ByteArrayInputStream(data, off, len));
    }

    public abstract ObjectId insert(int var1, long var2, InputStream var4) throws IOException;

    public abstract PackParser newPackParser(InputStream var1) throws IOException;

    public abstract void flush() throws IOException;

    public abstract void release();

    public static class Formatter
    extends ObjectInserter {
        public ObjectId insert(int objectType, long length, InputStream in) throws IOException {
            throw new UnsupportedOperationException();
        }

        public PackParser newPackParser(InputStream in) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void flush() throws IOException {
        }

        public void release() {
        }
    }
}

