/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetCommand
extends GitCommand<Ref> {
    private String ref;
    private ResetType mode;

    public ResetCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Ref call() throws IOException {
        Ref r;
        this.checkCallable();
        try {
            RevCommit commit;
            ObjectId commitId;
            RepositoryState state = this.repo.getRepositoryState();
            boolean merging = state.equals((Object)RepositoryState.MERGING) || state.equals((Object)RepositoryState.MERGING_RESOLVED);
            boolean cherryPicking = state.equals((Object)RepositoryState.CHERRY_PICKING) || state.equals((Object)RepositoryState.CHERRY_PICKING_RESOLVED);
            try {
                commitId = this.repo.resolve(this.ref);
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotRead, this.ref), e);
            }
            RevWalk rw = new RevWalk(this.repo);
            try {
                commit = rw.parseCommit(commitId);
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotReadCommit, commitId.toString()), e);
            }
            finally {
                rw.release();
            }
            RefUpdate ru = this.repo.updateRef("HEAD");
            ru.setNewObjectId(commitId);
            String refName = Repository.shortenRefName(this.ref);
            String message = "reset --" + this.mode.toString().toLowerCase() + " " + refName;
            ru.setRefLogMessage(message, false);
            if (ru.forceUpdate() == RefUpdate.Result.LOCK_FAILURE) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotLock, ru.getName()));
            }
            switch (this.mode) {
                case HARD: {
                    this.checkoutIndex(commit);
                    break;
                }
                case MIXED: {
                    this.resetIndex(commit);
                    break;
                }
                case SOFT: {
                    break;
                }
                case KEEP: 
                case MERGE: {
                    throw new UnsupportedOperationException();
                }
            }
            if (this.mode != ResetType.SOFT) {
                if (merging) {
                    this.resetMerge();
                } else if (cherryPicking) {
                    this.resetCherryPick();
                }
            }
            this.setCallable(false);
            r = ru.getRef();
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfResetCommand, e);
        }
        return r;
    }

    public ResetCommand setRef(String ref) {
        this.ref = ref;
        return this;
    }

    public ResetCommand setMode(ResetType mode) {
        this.mode = mode;
        return this;
    }

    private void resetIndex(RevCommit commit) throws IOException {
        DirCache dc = null;
        try {
            dc = this.repo.lockDirCache();
            dc.clear();
            DirCacheBuilder dcb = dc.builder();
            dcb.addTree(new byte[0], 0, this.repo.newObjectReader(), commit.getTree());
            dcb.commit();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
    }

    private void checkoutIndex(RevCommit commit) throws IOException {
        DirCache dc = null;
        try {
            dc = this.repo.lockDirCache();
            DirCacheCheckout checkout = new DirCacheCheckout(this.repo, dc, commit.getTree());
            checkout.setFailOnConflict(false);
            checkout.checkout();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
    }

    private void resetMerge() throws IOException {
        this.repo.writeMergeHeads(null);
        this.repo.writeMergeCommitMsg(null);
    }

    private void resetCherryPick() throws IOException {
        this.repo.writeCherryPickHead(null);
        this.repo.writeMergeCommitMsg(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResetType {
        SOFT,
        MIXED,
        HARD,
        MERGE,
        KEEP;

    }
}

