/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.util.Map;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebaseResult {
    static final RebaseResult UP_TO_DATE_RESULT = new RebaseResult(Status.UP_TO_DATE);
    private final Status mySatus;
    private final RevCommit currentCommit;
    private Map<String, ResolveMerger.MergeFailureReason> failingPaths;

    RebaseResult(Status status) {
        this.mySatus = status;
        this.currentCommit = null;
    }

    RebaseResult(RevCommit commit) {
        this.mySatus = Status.STOPPED;
        this.currentCommit = commit;
    }

    RebaseResult(Map<String, ResolveMerger.MergeFailureReason> failingPaths) {
        this.mySatus = Status.FAILED;
        this.currentCommit = null;
        this.failingPaths = failingPaths;
    }

    public Status getStatus() {
        return this.mySatus;
    }

    public RevCommit getCurrentCommit() {
        return this.currentCommit;
    }

    public Map<String, ResolveMerger.MergeFailureReason> getFailingPaths() {
        return this.failingPaths;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        OK,
        ABORTED,
        STOPPED,
        FAILED,
        UP_TO_DATE,
        FAST_FORWARD;

    }
}

