/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.InvalidMergeHeadsException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.FileTreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeCommand
extends GitCommand<MergeResult> {
    private MergeStrategy mergeStrategy = MergeStrategy.RESOLVE;
    private List<Ref> commits = new LinkedList<Ref>();

    protected MergeCommand(Repository repo) {
        super(repo);
    }

    @Override
    public MergeResult call() throws NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException, WrongRepositoryStateException, NoMessageException {
        this.checkCallable();
        if (this.commits.size() != 1) {
            throw new InvalidMergeHeadsException(this.commits.isEmpty() ? JGitText.get().noMergeHeadSpecified : MessageFormat.format(JGitText.get().mergeStrategyDoesNotSupportHeads, this.mergeStrategy.getName(), this.commits.size()));
        }
        RevWalk revWalk = null;
        try {
            Object dco;
            boolean noProblems;
            Ref head = this.repo.getRef("HEAD");
            if (head == null) {
                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
            }
            StringBuilder refLogMessage = new StringBuilder("merge ");
            revWalk = new RevWalk(this.repo);
            Ref ref = this.commits.get(0);
            refLogMessage.append(ref.getName());
            ObjectId objectId = ref.getPeeledObjectId();
            if (objectId == null) {
                objectId = ref.getObjectId();
            }
            RevCommit srcCommit = revWalk.lookupCommit(objectId);
            ObjectId headId = head.getObjectId();
            if (headId == null) {
                revWalk.parseHeaders(srcCommit);
                DirCacheCheckout dco2 = new DirCacheCheckout(this.repo, this.repo.lockDirCache(), srcCommit.getTree());
                dco2.setFailOnConflict(true);
                dco2.checkout();
                RefUpdate refUpdate = this.repo.updateRef(head.getTarget().getName());
                refUpdate.setNewObjectId(objectId);
                refUpdate.setExpectedOldObjectId(null);
                refUpdate.setRefLogMessage("initial pull", false);
                if (refUpdate.update() != RefUpdate.Result.NEW) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                this.setCallable(false);
                MergeResult mergeResult = new MergeResult(srcCommit, srcCommit, new ObjectId[]{null, srcCommit}, MergeResult.MergeStatus.FAST_FORWARD, this.mergeStrategy, null, null);
                return mergeResult;
            }
            RevCommit headCommit = revWalk.lookupCommit(headId);
            if (revWalk.isMergedInto(srcCommit, headCommit)) {
                this.setCallable(false);
                MergeResult refUpdate = new MergeResult(headCommit, srcCommit, new ObjectId[]{headCommit, srcCommit}, MergeResult.MergeStatus.ALREADY_UP_TO_DATE, this.mergeStrategy, null, null);
                return refUpdate;
            }
            if (revWalk.isMergedInto(headCommit, srcCommit)) {
                refLogMessage.append(": " + (Object)((Object)MergeResult.MergeStatus.FAST_FORWARD));
                DirCacheCheckout dco3 = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), srcCommit.getTree());
                dco3.setFailOnConflict(true);
                dco3.checkout();
                this.updateHead(refLogMessage, srcCommit, headId);
                this.setCallable(false);
                MergeResult mergeResult = new MergeResult(srcCommit, srcCommit, new ObjectId[]{headCommit, srcCommit}, MergeResult.MergeStatus.FAST_FORWARD, this.mergeStrategy, null, null);
                return mergeResult;
            }
            String mergeMessage = new MergeMessageFormatter().format(this.commits, head);
            this.repo.writeMergeCommitMsg(mergeMessage);
            this.repo.writeMergeHeads(Arrays.asList(ref.getObjectId()));
            ThreeWayMerger merger = (ThreeWayMerger)this.mergeStrategy.newMerger(this.repo);
            Map<String, org.eclipse.jgit.merge.MergeResult<?>> lowLevelResults = null;
            Map<String, ResolveMerger.MergeFailureReason> failingPaths = null;
            List<String> unmergedPaths = null;
            if (merger instanceof ResolveMerger) {
                ResolveMerger resolveMerger = (ResolveMerger)merger;
                resolveMerger.setCommitNames(new String[]{"BASE", "HEAD", ref.getName()});
                resolveMerger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                noProblems = merger.merge(headCommit, srcCommit);
                lowLevelResults = resolveMerger.getMergeResults();
                failingPaths = resolveMerger.getFailingPaths();
                unmergedPaths = resolveMerger.getUnmergedPaths();
            } else {
                noProblems = merger.merge(headCommit, srcCommit);
            }
            if (noProblems) {
                dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                ((DirCacheCheckout)dco).setFailOnConflict(true);
                ((DirCacheCheckout)dco).checkout();
                RevCommit newHead = new Git(this.getRepository()).commit().call();
                MergeResult mergeResult = new MergeResult(newHead.getId(), null, new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.MERGED, this.mergeStrategy, null, null);
                return mergeResult;
            }
            if (failingPaths != null) {
                this.repo.writeMergeCommitMsg(null);
                this.repo.writeMergeHeads(null);
                dco = new MergeResult(null, merger.getBaseCommit(0, 1), new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.FAILED, this.mergeStrategy, lowLevelResults, failingPaths, null);
                return dco;
            }
            String mergeMessageWithConflicts = new MergeMessageFormatter().formatWithConflicts(mergeMessage, unmergedPaths);
            this.repo.writeMergeCommitMsg(mergeMessageWithConflicts);
            MergeResult mergeResult = new MergeResult(null, merger.getBaseCommit(0, 1), new ObjectId[]{headCommit.getId(), srcCommit.getId()}, MergeResult.MergeStatus.CONFLICTING, this.mergeStrategy, lowLevelResults, null);
            return mergeResult;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfMergeCommand, e), e);
        }
        finally {
            if (revWalk != null) {
                revWalk.release();
            }
        }
    }

    private void updateHead(StringBuilder refLogMessage, ObjectId newHeadId, ObjectId oldHeadID) throws IOException, ConcurrentRefUpdateException {
        RefUpdate refUpdate = this.repo.updateRef("HEAD");
        refUpdate.setNewObjectId(newHeadId);
        refUpdate.setRefLogMessage(refLogMessage.toString(), false);
        refUpdate.setExpectedOldObjectId(oldHeadID);
        RefUpdate.Result rc = refUpdate.update();
        switch (rc) {
            case NEW: 
            case FAST_FORWARD: {
                return;
            }
            case REJECTED: 
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, refUpdate.getRef(), rc);
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", newHeadId.toString(), rc}));
    }

    public MergeCommand setStrategy(MergeStrategy mergeStrategy) {
        this.checkCallable();
        this.mergeStrategy = mergeStrategy;
        return this;
    }

    public MergeCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public MergeCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public MergeCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }
}

