/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileObjectDatabase;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.storage.file.ObjectDirectory;
import org.eclipse.jgit.storage.file.RefDirectory;
import org.eclipse.jgit.storage.file.ReflogReader;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.SystemReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRepository
extends Repository {
    private final FileBasedConfig systemConfig = SystemReader.getInstance().openSystemConfig(null, this.getFS());
    private final FileBasedConfig userConfig = SystemReader.getInstance().openUserConfig(this.systemConfig, this.getFS());
    private final FileBasedConfig repoConfig = new FileBasedConfig(this.userConfig, this.getFS().resolve(this.getDirectory(), "config"), this.getFS());
    private final RefDatabase refs;
    private final ObjectDirectory objectDatabase;

    public FileRepository(File gitDir) throws IOException {
        this((BaseRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDir)).setup());
    }

    public FileRepository(String gitDir) throws IOException {
        this(new File(gitDir));
    }

    public FileRepository(BaseRepositoryBuilder options) throws IOException {
        super(options);
        String repositoryFormatVersion;
        this.loadSystemConfig();
        this.loadUserConfig();
        this.loadRepoConfig();
        this.repoConfig.addChangeListener(new ConfigChangedListener(){

            public void onConfigChanged(ConfigChangedEvent event) {
                FileRepository.this.fireEvent(event);
            }
        });
        this.refs = new RefDirectory(this);
        this.objectDatabase = new ObjectDirectory(this.repoConfig, options.getObjectDirectory(), options.getAlternateObjectDirectories(), this.getFS());
        if (this.objectDatabase.exists() && !"0".equals(repositoryFormatVersion = this.getConfig().getString("core", null, "repositoryformatversion"))) {
            throw new IOException(MessageFormat.format(JGitText.get().unknownRepositoryFormat2, repositoryFormatVersion));
        }
    }

    private void loadSystemConfig() throws IOException {
        try {
            this.systemConfig.load();
        }
        catch (ConfigInvalidException e1) {
            IOException e2 = new IOException(MessageFormat.format(JGitText.get().systemConfigFileInvalid, this.systemConfig.getFile().getAbsolutePath(), e1));
            e2.initCause(e1);
            throw e2;
        }
    }

    private void loadUserConfig() throws IOException {
        try {
            this.userConfig.load();
        }
        catch (ConfigInvalidException e1) {
            IOException e2 = new IOException(MessageFormat.format(JGitText.get().userConfigFileInvalid, this.userConfig.getFile().getAbsolutePath(), e1));
            e2.initCause(e1);
            throw e2;
        }
    }

    private void loadRepoConfig() throws IOException {
        try {
            this.repoConfig.load();
        }
        catch (ConfigInvalidException e1) {
            IOException e2 = new IOException(JGitText.get().unknownRepositoryFormat);
            e2.initCause(e1);
            throw e2;
        }
    }

    @Override
    public void create(boolean bare) throws IOException {
        boolean fileMode;
        FileBasedConfig cfg = this.getConfig();
        if (cfg.getFile().exists()) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().repositoryAlreadyExists, this.getDirectory()));
        }
        FileUtils.mkdirs(this.getDirectory(), true);
        this.refs.create();
        this.objectDatabase.create();
        FileUtils.mkdir(new File(this.getDirectory(), "branches"));
        RefUpdate head = this.updateRef("HEAD");
        head.disableRefLog();
        head.link("refs/heads/master");
        if (this.getFS().supportsExecute()) {
            File tmp = File.createTempFile("try", "execute", this.getDirectory());
            this.getFS().setExecute(tmp, true);
            boolean on = this.getFS().canExecute(tmp);
            this.getFS().setExecute(tmp, false);
            boolean off = this.getFS().canExecute(tmp);
            FileUtils.delete(tmp);
            fileMode = on && !off;
        } else {
            fileMode = false;
        }
        cfg.setInt("core", null, "repositoryformatversion", 0);
        cfg.setBoolean("core", null, "filemode", fileMode);
        if (bare) {
            cfg.setBoolean("core", null, "bare", true);
        }
        cfg.setBoolean("core", null, "logallrefupdates", !bare);
        cfg.setBoolean("core", null, "autocrlf", false);
        cfg.save();
    }

    public File getObjectsDirectory() {
        return this.objectDatabase.getDirectory();
    }

    @Override
    public ObjectDirectory getObjectDatabase() {
        return this.objectDatabase;
    }

    @Override
    public RefDatabase getRefDatabase() {
        return this.refs;
    }

    @Override
    public FileBasedConfig getConfig() {
        if (this.systemConfig.isOutdated()) {
            try {
                this.loadSystemConfig();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.userConfig.isOutdated()) {
            try {
                this.loadUserConfig();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.repoConfig.isOutdated()) {
            try {
                this.loadRepoConfig();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.repoConfig;
    }

    @Override
    public Set<ObjectId> getAdditionalHaves() {
        HashSet<ObjectId> r = new HashSet<ObjectId>();
        for (FileObjectDatabase.AlternateHandle d : this.objectDatabase.myAlternates()) {
            if (!(d instanceof FileObjectDatabase.AlternateRepository)) continue;
            FileRepository repo = ((FileObjectDatabase.AlternateRepository)d).repository;
            for (Ref ref : repo.getAllRefs().values()) {
                if (ref.getObjectId() != null) {
                    r.add(ref.getObjectId());
                }
                if (ref.getPeeledObjectId() == null) continue;
                r.add(ref.getPeeledObjectId());
            }
            r.addAll(((Repository)repo).getAdditionalHaves());
        }
        return r;
    }

    public void openPack(File pack, File idx) throws IOException {
        this.objectDatabase.openPack(pack, idx);
    }

    @Override
    public void scanForRepoChanges() throws IOException {
        this.getAllRefs();
        if (!this.isBare()) {
            this.getIndex();
        }
    }

    @Override
    public ReflogReader getReflogReader(String refName) throws IOException {
        Ref ref = this.getRef(refName);
        if (ref != null) {
            return new ReflogReader(this, ref.getName());
        }
        return null;
    }
}

