/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.lang.ref.SoftReference;
import org.eclipse.jgit.storage.file.PackFile;
import org.eclipse.jgit.storage.file.WindowCacheConfig;

class DeltaBaseCache {
    private static final int CACHE_SZ = 1024;
    private static final SoftReference<Entry> DEAD = new SoftReference<Object>(null);
    private static int maxByteCount = new WindowCacheConfig().getDeltaBaseCacheLimit();
    private static final Slot[] cache = new Slot[1024];
    private static Slot lruHead;
    private static Slot lruTail;
    private static int openByteCount;

    private static int hash(long position) {
        return (int)position << 22 >>> 22;
    }

    static synchronized void reconfigure(WindowCacheConfig cfg) {
        int dbLimit = cfg.getDeltaBaseCacheLimit();
        if (maxByteCount != dbLimit) {
            maxByteCount = dbLimit;
            DeltaBaseCache.releaseMemory();
        }
    }

    static synchronized Entry get(PackFile pack, long position) {
        Entry buf;
        Slot e = cache[DeltaBaseCache.hash(position)];
        if (e.provider == pack && e.position == position && (buf = e.data.get()) != null) {
            DeltaBaseCache.moveToHead(e);
            return buf;
        }
        return null;
    }

    static synchronized void store(PackFile pack, long position, byte[] data, int objectType) {
        if (data.length > maxByteCount) {
            return;
        }
        Slot e = cache[DeltaBaseCache.hash(position)];
        DeltaBaseCache.clearEntry(e);
        openByteCount += data.length;
        DeltaBaseCache.releaseMemory();
        e.provider = pack;
        e.position = position;
        e.sz = data.length;
        e.data = new SoftReference<Entry>(new Entry(data, objectType));
        DeltaBaseCache.moveToHead(e);
    }

    private static void releaseMemory() {
        while (openByteCount > maxByteCount && lruTail != null) {
            Slot currOldest = lruTail;
            Slot nextOldest = currOldest.lruPrev;
            DeltaBaseCache.clearEntry(currOldest);
            currOldest.lruPrev = null;
            currOldest.lruNext = null;
            if (nextOldest == null) {
                lruHead = null;
            } else {
                nextOldest.lruNext = null;
            }
            lruTail = nextOldest;
        }
    }

    static synchronized void purge(PackFile file) {
        for (Slot e : cache) {
            if (e.provider != file) continue;
            DeltaBaseCache.clearEntry(e);
            DeltaBaseCache.unlink(e);
        }
    }

    private static void moveToHead(Slot e) {
        DeltaBaseCache.unlink(e);
        e.lruPrev = null;
        e.lruNext = lruHead;
        if (lruHead != null) {
            DeltaBaseCache.lruHead.lruPrev = e;
        } else {
            lruTail = e;
        }
        lruHead = e;
    }

    private static void unlink(Slot e) {
        Slot prev = e.lruPrev;
        Slot next = e.lruNext;
        if (prev != null) {
            prev.lruNext = next;
        }
        if (next != null) {
            next.lruPrev = prev;
        }
    }

    private static void clearEntry(Slot e) {
        openByteCount -= e.sz;
        e.provider = null;
        e.data = DEAD;
        e.sz = 0;
    }

    private DeltaBaseCache() {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ SoftReference access$100() {
        return DEAD;
    }

    static {
        for (int i = 0; i < 1024; ++i) {
            DeltaBaseCache.cache[i] = new Slot();
        }
    }

    static class Entry {
        final byte[] data;
        final int type;

        Entry(byte[] aData, int aType) {
            this.data = aData;
            this.type = aType;
        }
    }

    private static class Slot {
        Slot lruPrev;
        Slot lruNext;
        PackFile provider;
        long position;
        int sz;
        SoftReference<Entry> data = DeltaBaseCache.access$100();

        private Slot() {
        }
    }
}

