/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class IndexDiffFilter
extends TreeFilter {
    private final int dirCache;
    private final int workingTree;
    private final boolean honorIgnores;

    public IndexDiffFilter(int dirCacheIndex, int workingTreeIndex) {
        this(dirCacheIndex, workingTreeIndex, true);
    }

    public IndexDiffFilter(int dirCacheIndex, int workingTreeIndex, boolean honorIgnores) {
        this.dirCache = dirCacheIndex;
        this.workingTree = workingTreeIndex;
        this.honorIgnores = honorIgnores;
    }

    public boolean include(TreeWalk tw) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        int wm = tw.getRawMode(this.workingTree);
        if (wm == 0) {
            return true;
        }
        int cnt = tw.getTreeCount();
        int dm = tw.getRawMode(this.dirCache);
        if (dm == 0) {
            if (this.honorIgnores && this.workingTree(tw).isEntryIgnored()) {
                int i;
                for (i = 0; i < cnt && (i == this.dirCache || i == this.workingTree || tw.getRawMode(i) == 0); ++i) {
                }
                return i != cnt;
            }
            return true;
        }
        if (tw.isSubtree()) {
            return true;
        }
        for (int i = 0; i < cnt; ++i) {
            if (i == this.dirCache || i == this.workingTree || tw.getRawMode(i) == dm && tw.idEqual(i, this.dirCache)) continue;
            return true;
        }
        WorkingTreeIterator wi = this.workingTree(tw);
        DirCacheIterator di = tw.getTree(this.dirCache, DirCacheIterator.class);
        return wi.isModified(di.getDirCacheEntry(), true);
    }

    private WorkingTreeIterator workingTree(TreeWalk tw) {
        return tw.getTree(this.workingTree, WorkingTreeIterator.class);
    }

    public boolean shouldBeRecursive() {
        return true;
    }

    public TreeFilter clone() {
        return this;
    }

    public String toString() {
        return "INDEX_DIFF_FILTER";
    }
}

