/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.Serializable;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.lib.Ref;

public class RefSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String WILDCARD_SUFFIX = "/*";
    private boolean force;
    private boolean wildcard;
    private String srcName;
    private String dstName;

    public static boolean isWildcard(String s) {
        return s != null && s.endsWith(WILDCARD_SUFFIX);
    }

    public RefSpec() {
        this.force = false;
        this.wildcard = false;
        this.srcName = "HEAD";
        this.dstName = null;
    }

    public RefSpec(String spec) {
        int c;
        String s = spec;
        if (s.startsWith("+")) {
            this.force = true;
            s = s.substring(1);
        }
        if ((c = s.lastIndexOf(58)) == 0) {
            if (RefSpec.isWildcard(s = s.substring(1))) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidWildcards, spec));
            }
            this.dstName = s;
        } else if (c > 0) {
            this.srcName = s.substring(0, c);
            this.dstName = s.substring(c + 1);
            if (RefSpec.isWildcard(this.srcName) && RefSpec.isWildcard(this.dstName)) {
                this.wildcard = true;
            } else if (RefSpec.isWildcard(this.srcName) || RefSpec.isWildcard(this.dstName)) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidWildcards, spec));
            }
        } else {
            if (RefSpec.isWildcard(s)) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidWildcards, spec));
            }
            this.srcName = s;
        }
    }

    private RefSpec(RefSpec p) {
        this.force = p.isForceUpdate();
        this.wildcard = p.isWildcard();
        this.srcName = p.getSource();
        this.dstName = p.getDestination();
    }

    public boolean isForceUpdate() {
        return this.force;
    }

    public RefSpec setForceUpdate(boolean forceUpdate) {
        RefSpec r = new RefSpec(this);
        r.force = forceUpdate;
        return r;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public String getSource() {
        return this.srcName;
    }

    public RefSpec setSource(String source) {
        RefSpec r = new RefSpec(this);
        r.srcName = source;
        if (RefSpec.isWildcard(r.srcName) && r.dstName == null) {
            throw new IllegalStateException(JGitText.get().destinationIsNotAWildcard);
        }
        if (RefSpec.isWildcard(r.srcName) != RefSpec.isWildcard(r.dstName)) {
            throw new IllegalStateException(JGitText.get().sourceDestinationMustMatch);
        }
        return r;
    }

    public String getDestination() {
        return this.dstName;
    }

    public RefSpec setDestination(String destination) {
        RefSpec r = new RefSpec(this);
        r.dstName = destination;
        if (RefSpec.isWildcard(r.dstName) && r.srcName == null) {
            throw new IllegalStateException(JGitText.get().sourceIsNotAWildcard);
        }
        if (RefSpec.isWildcard(r.srcName) != RefSpec.isWildcard(r.dstName)) {
            throw new IllegalStateException(JGitText.get().sourceDestinationMustMatch);
        }
        return r;
    }

    public RefSpec setSourceDestination(String source, String destination) {
        if (RefSpec.isWildcard(source) != RefSpec.isWildcard(destination)) {
            throw new IllegalStateException(JGitText.get().sourceDestinationMustMatch);
        }
        RefSpec r = new RefSpec(this);
        r.wildcard = RefSpec.isWildcard(source);
        r.srcName = source;
        r.dstName = destination;
        return r;
    }

    public boolean matchSource(String r) {
        return this.match(r, this.getSource());
    }

    public boolean matchSource(Ref r) {
        return this.match(r.getName(), this.getSource());
    }

    public boolean matchDestination(String r) {
        return this.match(r, this.getDestination());
    }

    public boolean matchDestination(Ref r) {
        return this.match(r.getName(), this.getDestination());
    }

    public RefSpec expandFromSource(String r) {
        return this.isWildcard() ? new RefSpec(this).expandFromSourceImp(r) : this;
    }

    private RefSpec expandFromSourceImp(String name) {
        String psrc = this.srcName;
        String pdst = this.dstName;
        this.wildcard = false;
        this.srcName = name;
        this.dstName = pdst.substring(0, pdst.length() - 1) + name.substring(psrc.length() - 1);
        return this;
    }

    public RefSpec expandFromSource(Ref r) {
        return this.expandFromSource(r.getName());
    }

    public RefSpec expandFromDestination(String r) {
        return this.isWildcard() ? new RefSpec(this).expandFromDstImp(r) : this;
    }

    private RefSpec expandFromDstImp(String name) {
        String psrc = this.srcName;
        String pdst = this.dstName;
        this.wildcard = false;
        this.srcName = psrc.substring(0, psrc.length() - 1) + name.substring(pdst.length() - 1);
        this.dstName = name;
        return this;
    }

    public RefSpec expandFromDestination(Ref r) {
        return this.expandFromDestination(r.getName());
    }

    private boolean match(String refName, String s) {
        if (s == null) {
            return false;
        }
        if (this.isWildcard()) {
            return refName.startsWith(s.substring(0, s.length() - 1));
        }
        return refName.equals(s);
    }

    public int hashCode() {
        int hc = 0;
        if (this.getSource() != null) {
            hc = hc * 31 + this.getSource().hashCode();
        }
        if (this.getDestination() != null) {
            hc = hc * 31 + this.getDestination().hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RefSpec)) {
            return false;
        }
        RefSpec b = (RefSpec)obj;
        if (this.isForceUpdate() != b.isForceUpdate()) {
            return false;
        }
        if (this.isWildcard() != b.isWildcard()) {
            return false;
        }
        if (!RefSpec.eq(this.getSource(), b.getSource())) {
            return false;
        }
        return RefSpec.eq(this.getDestination(), b.getDestination());
    }

    private static boolean eq(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        if (this.isForceUpdate()) {
            r.append('+');
        }
        if (this.getSource() != null) {
            r.append(this.getSource());
        }
        if (this.getDestination() != null) {
            r.append(':');
            r.append(this.getDestination());
        }
        return r.toString();
    }
}

