/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.TimeZone;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;

public abstract class SystemReader {
    private static SystemReader INSTANCE = new SystemReader(){
        private volatile String hostname;

        public String getenv(String variable) {
            return System.getenv(variable);
        }

        public String getProperty(String key) {
            return System.getProperty(key);
        }

        public FileBasedConfig openUserConfig(FS fs) {
            File home = fs.userHome();
            return new FileBasedConfig(new File(home, ".gitconfig"), fs);
        }

        public String getHostname() {
            if (this.hostname == null) {
                try {
                    InetAddress localMachine = InetAddress.getLocalHost();
                    this.hostname = localMachine.getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    this.hostname = "localhost";
                }
                assert (this.hostname != null);
            }
            return this.hostname;
        }

        public long getCurrentTime() {
            return System.currentTimeMillis();
        }

        public int getTimezone(long when) {
            return TimeZone.getDefault().getOffset(when) / 60000;
        }
    };

    public static SystemReader getInstance() {
        return INSTANCE;
    }

    public static void setInstance(SystemReader newReader) {
        INSTANCE = newReader;
    }

    public abstract String getHostname();

    public abstract String getenv(String var1);

    public abstract String getProperty(String var1);

    public abstract FileBasedConfig openUserConfig(FS var1);

    public abstract long getCurrentTime();

    public abstract int getTimezone(long var1);
}

