/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.pack;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.storage.pack.DeltaCache;
import org.eclipse.jgit.storage.pack.DeltaIndex;
import org.eclipse.jgit.storage.pack.DeltaWindowEntry;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackWriter;
import org.eclipse.jgit.util.TemporaryBuffer;

class DeltaWindow {
    private static final int NEXT_RES = 0;
    private static final int NEXT_SRC = 1;
    private final PackConfig config;
    private final DeltaCache deltaCache;
    private final ObjectReader reader;
    private final DeltaWindowEntry[] window;
    private final long maxMemory;
    private final int maxDepth;
    private long loaded;
    private int resSlot;
    private int resMaxDepth;
    private DeltaWindowEntry res;
    private TemporaryBuffer.Heap bestDelta;
    private int bestSlot;
    private Deflater deflater;

    DeltaWindow(PackConfig pc, DeltaCache dc, ObjectReader or) {
        this.config = pc;
        this.deltaCache = dc;
        this.reader = or;
        this.window = new DeltaWindowEntry[this.config.getDeltaSearchWindowSize() + 1];
        for (int i = 0; i < this.window.length; ++i) {
            this.window[i] = new DeltaWindowEntry();
        }
        this.maxMemory = this.config.getDeltaSearchMemoryLimit();
        this.maxDepth = this.config.getMaxDeltaDepth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void search(ProgressMonitor monitor, ObjectToPack[] toSearch, int off, int cnt) throws IOException {
        try {
            int end = off + cnt;
            while (off < end) {
                monitor.update(1);
                this.res = this.window[this.resSlot];
                if (0L < this.maxMemory) {
                    this.clear(this.res);
                    int tail = this.next(this.resSlot);
                    long need = DeltaWindow.estimateSize(toSearch[off]);
                    while (this.maxMemory < this.loaded + need && tail != this.resSlot) {
                        this.clear(this.window[tail]);
                        tail = this.next(tail);
                    }
                }
                this.res.set(toSearch[off]);
                if (this.res.object.isEdge()) {
                    this.keepInWindow();
                } else {
                    this.search();
                }
                ++off;
            }
            Object var10_8 = null;
            if (this.deflater != null) {
                this.deflater.end();
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (this.deflater != null) {
                this.deflater.end();
            }
            throw throwable;
        }
    }

    private static long estimateSize(ObjectToPack ent) {
        return DeltaIndex.estimateIndexSize(ent.getWeight());
    }

    private void clear(DeltaWindowEntry ent) {
        if (ent.index != null) {
            this.loaded -= ent.index.getIndexSize();
        } else if (this.res.buffer != null) {
            this.loaded -= (long)ent.buffer.length;
        }
        ent.set(null);
    }

    private void search() throws IOException {
        DeltaWindowEntry src;
        this.resMaxDepth = this.maxDepth;
        int srcSlot = this.prior(this.resSlot);
        while (srcSlot != this.resSlot && !(src = this.window[srcSlot]).empty()) {
            if (this.delta(src, srcSlot) == 0) {
                this.bestDelta = null;
                return;
            }
            srcSlot = this.prior(srcSlot);
        }
        if (this.bestDelta == null) {
            this.keepInWindow();
            return;
        }
        ObjectToPack srcObj = this.window[this.bestSlot].object;
        ObjectToPack resObj = this.res.object;
        if (srcObj.isEdge()) {
            resObj.setDeltaBase(srcObj.copy());
        } else {
            resObj.setDeltaBase(srcObj);
        }
        resObj.setDeltaDepth(srcObj.getDeltaDepth() + 1);
        resObj.clearReuseAsIs();
        this.cacheDelta(srcObj, resObj);
        this.bestDelta = null;
        if (resObj.getDeltaDepth() == this.maxDepth) {
            return;
        }
        this.shuffleBaseUpInPriority();
        this.keepInWindow();
    }

    private int delta(DeltaWindowEntry src, int srcSlot) throws IOException {
        byte[] resBuf;
        DeltaIndex srcIndex;
        if (src.type() != this.res.type()) {
            this.keepInWindow();
            return 0;
        }
        if (src.depth() > this.resMaxDepth) {
            return 1;
        }
        int msz = DeltaWindow.deltaSizeLimit(this.res, this.resMaxDepth, src);
        if (msz <= 8) {
            return 1;
        }
        if (this.res.size() - src.size() > msz) {
            return 1;
        }
        if (this.res.size() < src.size() / 16) {
            return 1;
        }
        try {
            srcIndex = this.index(src);
        }
        catch (LargeObjectException tooBig) {
            this.dropFromWindow(srcSlot);
            return 1;
        }
        catch (IOException notAvailable) {
            if (src.object.isEdge()) {
                this.dropFromWindow(srcSlot);
                return 1;
            }
            throw notAvailable;
        }
        try {
            resBuf = this.buffer(this.res);
        }
        catch (LargeObjectException tooBig) {
            return 0;
        }
        if (this.bestDelta != null && this.bestDelta.length() < (long)msz) {
            msz = (int)this.bestDelta.length();
        }
        TemporaryBuffer.Heap delta = new TemporaryBuffer.Heap(msz);
        try {
            if (!srcIndex.encode(delta, resBuf, msz)) {
                return 1;
            }
        }
        catch (IOException deltaTooBig) {
            return 1;
        }
        if (this.isBetterDelta(src, delta)) {
            this.bestDelta = delta;
            this.bestSlot = srcSlot;
        }
        return 1;
    }

    private void cacheDelta(ObjectToPack srcObj, ObjectToPack resObj) {
        if (Integer.MAX_VALUE < this.bestDelta.length()) {
            return;
        }
        int rawsz = (int)this.bestDelta.length();
        if (this.deltaCache.canCache(rawsz, srcObj, resObj)) {
            try {
                byte[] zbuf = new byte[DeltaWindow.deflateBound(rawsz)];
                ZipStream zs = new ZipStream(this.deflater(), zbuf);
                this.bestDelta.writeTo(zs, null);
                this.bestDelta = null;
                int len = zs.finish();
                resObj.setCachedDelta(this.deltaCache.cache(zbuf, len, rawsz));
                resObj.setCachedSize(rawsz);
            }
            catch (IOException err) {
                this.deltaCache.credit(rawsz);
            }
            catch (OutOfMemoryError err) {
                this.deltaCache.credit(rawsz);
            }
        }
    }

    private static int deflateBound(int insz) {
        return insz + (insz + 7 >> 3) + (insz + 63 >> 6) + 11;
    }

    private void shuffleBaseUpInPriority() {
        this.window[this.resSlot] = this.window[this.bestSlot];
        DeltaWindowEntry next = this.res;
        int slot = this.prior(this.resSlot);
        while (slot != this.bestSlot) {
            DeltaWindowEntry e = this.window[slot];
            this.window[slot] = next;
            next = e;
            slot = this.prior(slot);
        }
        this.window[slot] = next;
    }

    private void keepInWindow() {
        this.resSlot = this.next(this.resSlot);
    }

    private int next(int slot) {
        if (++slot == this.window.length) {
            return 0;
        }
        return slot;
    }

    private int prior(int slot) {
        if (slot == 0) {
            return this.window.length - 1;
        }
        return slot - 1;
    }

    private void dropFromWindow(int srcSlot) {
    }

    private boolean isBetterDelta(DeltaWindowEntry src, TemporaryBuffer.Heap resDelta) {
        if (this.bestDelta == null) {
            return true;
        }
        if (resDelta.length() == this.bestDelta.length()) {
            return src.depth() < this.window[this.bestSlot].depth();
        }
        return resDelta.length() < this.bestDelta.length();
    }

    private static int deltaSizeLimit(DeltaWindowEntry res, int maxDepth, DeltaWindowEntry src) {
        int limit = res.size() / 2 - 20;
        int remainingDepth = maxDepth - src.depth();
        return limit * remainingDepth / maxDepth;
    }

    private DeltaIndex index(DeltaWindowEntry ent) throws MissingObjectException, IncorrectObjectTypeException, IOException, LargeObjectException {
        DeltaIndex idx = ent.index;
        if (idx == null) {
            try {
                idx = new DeltaIndex(this.buffer(ent));
            }
            catch (OutOfMemoryError noMemory) {
                LargeObjectException.OutOfMemory e = new LargeObjectException.OutOfMemory(noMemory);
                e.setObjectId(ent.object);
                throw e;
            }
            if (0L < this.maxMemory) {
                this.loaded += idx.getIndexSize() - idx.getSourceSize();
            }
            ent.index = idx;
        }
        return idx;
    }

    private byte[] buffer(DeltaWindowEntry ent) throws MissingObjectException, IncorrectObjectTypeException, IOException, LargeObjectException {
        byte[] buf = ent.buffer;
        if (buf == null) {
            buf = PackWriter.buffer(this.config, this.reader, ent.object);
            if (0L < this.maxMemory) {
                this.loaded += (long)buf.length;
            }
            ent.buffer = buf;
        }
        return buf;
    }

    private Deflater deflater() {
        if (this.deflater == null) {
            this.deflater = new Deflater(this.config.getCompressionLevel());
        } else {
            this.deflater.reset();
        }
        return this.deflater;
    }

    static final class ZipStream
    extends OutputStream {
        private final Deflater deflater;
        private final byte[] zbuf;
        private int outPtr;

        ZipStream(Deflater deflater, byte[] zbuf) {
            this.deflater = deflater;
            this.zbuf = zbuf;
        }

        int finish() throws IOException {
            this.deflater.finish();
            while (true) {
                if (this.outPtr == this.zbuf.length) {
                    throw new EOFException();
                }
                int n = this.deflater.deflate(this.zbuf, this.outPtr, this.zbuf.length - this.outPtr);
                if (n == 0) {
                    if (this.deflater.finished()) {
                        return this.outPtr;
                    }
                    throw new IOException();
                }
                this.outPtr += n;
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.deflater.setInput(b, off, len);
            while (true) {
                if (this.outPtr == this.zbuf.length) {
                    throw new EOFException();
                }
                int n = this.deflater.deflate(this.zbuf, this.outPtr, this.zbuf.length - this.outPtr);
                if (n == 0) {
                    if (this.deflater.needsInput()) break;
                    throw new IOException();
                }
                this.outPtr += n;
            }
        }

        public void write(int b) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

