/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.sshd;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.AbstractUserAuthFactory;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.openssh.kdf.BCryptKdfOptions;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationCanceledException;
import org.eclipse.jgit.internal.transport.sshd.CachingKeyPairProvider;
import org.eclipse.jgit.internal.transport.sshd.GssApiWithMicAuthFactory;
import org.eclipse.jgit.internal.transport.sshd.JGitPasswordAuthFactory;
import org.eclipse.jgit.internal.transport.sshd.JGitServerKeyVerifier;
import org.eclipse.jgit.internal.transport.sshd.JGitSshClient;
import org.eclipse.jgit.internal.transport.sshd.JGitSshConfig;
import org.eclipse.jgit.internal.transport.sshd.JGitUserInteraction;
import org.eclipse.jgit.internal.transport.sshd.OpenSshServerKeyDatabase;
import org.eclipse.jgit.internal.transport.sshd.PasswordProviderWrapper;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshConfigStore;
import org.eclipse.jgit.transport.SshConstants;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.DefaultProxyDataFactory;
import org.eclipse.jgit.transport.sshd.IdentityPasswordProvider;
import org.eclipse.jgit.transport.sshd.KeyCache;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.transport.sshd.ProxyDataFactory;
import org.eclipse.jgit.transport.sshd.ServerKeyDatabase;
import org.eclipse.jgit.transport.sshd.SshdSession;
import org.eclipse.jgit.util.FS;

public class SshdSessionFactory
extends SshSessionFactory
implements Closeable {
    private static final String MINA_SSHD = "mina-sshd";
    private final AtomicBoolean closing = new AtomicBoolean();
    private final Set<SshdSession> sessions = new HashSet<SshdSession>();
    private final Map<Tuple, HostConfigEntryResolver> defaultHostConfigEntryResolver = new ConcurrentHashMap<Tuple, HostConfigEntryResolver>();
    private final Map<Tuple, ServerKeyDatabase> defaultServerKeyDatabase = new ConcurrentHashMap<Tuple, ServerKeyDatabase>();
    private final Map<Tuple, Iterable<KeyPair>> defaultKeys = new ConcurrentHashMap<Tuple, Iterable<KeyPair>>();
    private final KeyCache keyCache;
    private final ProxyDataFactory proxies;
    private File sshDirectory;
    private File homeDirectory;

    public SshdSessionFactory() {
        this(null, new DefaultProxyDataFactory());
    }

    public SshdSessionFactory(KeyCache keyCache, ProxyDataFactory proxies) {
        this.keyCache = keyCache;
        this.proxies = proxies;
        BCryptKdfOptions.setMaxAllowedRounds((int)16384);
    }

    public String getType() {
        return MINA_SSHD;
    }

    public SshdSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
        SshdSession session = null;
        try {
            session = new SshdSession(uri, () -> {
                File sshDir;
                File home = this.getHomeDirectory();
                if (home == null) {
                    home = FS.DETECTED.userHome();
                }
                if ((sshDir = this.getSshDirectory()) == null) {
                    sshDir = new File(home, ".ssh");
                }
                HostConfigEntryResolver configFile = this.getHostConfigEntryResolver(home, sshDir);
                KeyIdentityProvider defaultKeysProvider = this.toKeyIdentityProvider(this.getDefaultKeys(sshDir));
                SshClient client = (SshClient)((ClientBuilder)((ClientBuilder)((ClientBuilder)ClientBuilder.builder().factory(JGitSshClient::new)).filePasswordProvider(this.createFilePasswordProvider(() -> this.createKeyPasswordProvider(credentialsProvider))).hostConfigEntryResolver(configFile).serverKeyVerifier((ServerKeyVerifier)new JGitServerKeyVerifier(this.getServerKeyDatabase(home, sshDir))).signatureFactories(SshdSessionFactory.getSignatureFactories())).compressionFactories(new ArrayList(BuiltinCompressions.VALUES))).build();
                client.setUserInteraction((UserInteraction)new JGitUserInteraction(credentialsProvider));
                client.setUserAuthFactories(this.getUserAuthFactories());
                client.setKeyIdentityProvider(defaultKeysProvider);
                JGitSshClient jgitClient = (JGitSshClient)client;
                jgitClient.setKeyCache(this.getKeyCache());
                jgitClient.setCredentialsProvider(credentialsProvider);
                jgitClient.setProxyDatabase(this.proxies);
                String defaultAuths = this.getDefaultPreferredAuthentications();
                if (defaultAuths != null) {
                    jgitClient.setAttribute(JGitSshClient.PREFERRED_AUTHENTICATIONS, defaultAuths);
                }
                return client;
            });
            session.addCloseListener(s -> this.unregister(s));
            this.register(session);
            session.connect(Duration.ofMillis(tms));
            return session;
        }
        catch (Exception e) {
            this.unregister(session);
            if (e instanceof TransportException) {
                throw (TransportException)e;
            }
            Throwable cause = e;
            if (e instanceof SshException && e.getCause() instanceof AuthenticationCanceledException) {
                cause = e.getCause();
            }
            throw new TransportException(uri, cause.getMessage(), cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        KeyCache cache;
        this.closing.set(true);
        boolean cleanKeys = false;
        SshdSessionFactory sshdSessionFactory = this;
        synchronized (sshdSessionFactory) {
            cleanKeys = this.sessions.isEmpty();
        }
        if (cleanKeys && (cache = this.getKeyCache()) != null) {
            cache.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(SshdSession newSession) throws IOException {
        if (newSession == null) {
            return;
        }
        if (this.closing.get()) {
            throw new IOException(SshdText.get().sshClosingDown);
        }
        SshdSessionFactory sshdSessionFactory = this;
        synchronized (sshdSessionFactory) {
            this.sessions.add(newSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(SshdSession oldSession) {
        KeyCache cache;
        boolean cleanKeys = false;
        SshdSessionFactory sshdSessionFactory = this;
        synchronized (sshdSessionFactory) {
            this.sessions.remove(oldSession);
            cleanKeys = this.closing.get() && this.sessions.isEmpty();
        }
        if (cleanKeys && (cache = this.getKeyCache()) != null) {
            cache.close();
        }
    }

    public void setHomeDirectory(@NonNull File homeDir) {
        this.homeDirectory = homeDir.isAbsolute() ? homeDir : homeDir.getAbsoluteFile();
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public void setSshDirectory(@NonNull File sshDir) {
        this.sshDirectory = sshDir.isAbsolute() ? sshDir : sshDir.getAbsoluteFile();
    }

    public File getSshDirectory() {
        return this.sshDirectory;
    }

    @NonNull
    private HostConfigEntryResolver getHostConfigEntryResolver(@NonNull File homeDir, @NonNull File sshDir) {
        return this.defaultHostConfigEntryResolver.computeIfAbsent(new Tuple(new Object[]{homeDir, sshDir}), t -> new JGitSshConfig(this.createSshConfigStore(homeDir, this.getSshConfig(sshDir), SshdSessionFactory.getLocalUserName())));
    }

    protected File getSshConfig(@NonNull File sshDir) {
        return new File(sshDir, "config");
    }

    protected SshConfigStore createSshConfigStore(@NonNull File homeDir, File configFile, String localUserName) {
        return configFile == null ? null : new OpenSshConfigFile(homeDir, configFile, localUserName);
    }

    @NonNull
    protected ServerKeyDatabase getServerKeyDatabase(@NonNull File homeDir, @NonNull File sshDir) {
        return this.defaultServerKeyDatabase.computeIfAbsent(new Tuple(new Object[]{homeDir, sshDir}), t -> this.createServerKeyDatabase(homeDir, sshDir));
    }

    @NonNull
    protected ServerKeyDatabase createServerKeyDatabase(@NonNull File homeDir, @NonNull File sshDir) {
        return new OpenSshServerKeyDatabase(true, this.getDefaultKnownHostsFiles(sshDir));
    }

    @NonNull
    protected List<Path> getDefaultKnownHostsFiles(@NonNull File sshDir) {
        return Arrays.asList(sshDir.toPath().resolve("known_hosts"), sshDir.toPath().resolve("known_hosts2"));
    }

    @NonNull
    protected Iterable<KeyPair> getDefaultKeys(@NonNull File sshDir) {
        List<Path> defaultIdentities = this.getDefaultIdentities(sshDir);
        return this.defaultKeys.computeIfAbsent(new Tuple(defaultIdentities.toArray(new Path[0])), t -> new CachingKeyPairProvider(defaultIdentities, this.getKeyCache()));
    }

    private KeyIdentityProvider toKeyIdentityProvider(Iterable<KeyPair> keys) {
        if (keys instanceof KeyIdentityProvider) {
            return (KeyIdentityProvider)keys;
        }
        return session -> keys;
    }

    @NonNull
    protected List<Path> getDefaultIdentities(@NonNull File sshDir) {
        return Arrays.asList(SshConstants.DEFAULT_IDENTITIES).stream().map(s -> new File(sshDir, (String)s).toPath()).filter(path -> Files.exists(path, new LinkOption[0])).collect(Collectors.toList());
    }

    protected final KeyCache getKeyCache() {
        return this.keyCache;
    }

    @NonNull
    protected KeyPasswordProvider createKeyPasswordProvider(CredentialsProvider provider) {
        return new IdentityPasswordProvider(provider);
    }

    @NonNull
    private FilePasswordProvider createFilePasswordProvider(Supplier<KeyPasswordProvider> providerFactory) {
        return new PasswordProviderWrapper(providerFactory);
    }

    @NonNull
    private List<UserAuthFactory> getUserAuthFactories() {
        return Collections.unmodifiableList(Arrays.asList(new AbstractUserAuthFactory[]{GssApiWithMicAuthFactory.INSTANCE, UserAuthPublicKeyFactory.INSTANCE, JGitPasswordAuthFactory.INSTANCE, UserAuthKeyboardInteractiveFactory.INSTANCE}));
    }

    protected String getDefaultPreferredAuthentications() {
        return null;
    }

    private static List<NamedFactory<Signature>> getSignatureFactories() {
        return Arrays.asList(BuiltinSignatures.nistp256_cert, BuiltinSignatures.nistp384_cert, BuiltinSignatures.nistp521_cert, BuiltinSignatures.ed25519_cert, BuiltinSignatures.rsaSHA512_cert, BuiltinSignatures.rsaSHA256_cert, BuiltinSignatures.rsa_cert, BuiltinSignatures.nistp256, BuiltinSignatures.nistp384, BuiltinSignatures.nistp521, BuiltinSignatures.ed25519, BuiltinSignatures.sk_ecdsa_sha2_nistp256, BuiltinSignatures.sk_ssh_ed25519, BuiltinSignatures.rsaSHA512, BuiltinSignatures.rsaSHA256, BuiltinSignatures.rsa, BuiltinSignatures.dsa_cert, BuiltinSignatures.dsa);
    }

    private static final class Tuple {
        private Object[] objects;

        public Tuple(Object[] objects) {
            this.objects = objects;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == Tuple.class) {
                Tuple other = (Tuple)obj;
                return Arrays.equals(this.objects, other.objects);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.objects);
        }
    }
}

