/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.File;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.NB;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(usage="usage_TextHashFunctions")
class TextHashFunctions
extends TextBuiltin {
    final Hash sha1 = new Hash(){
        private final MessageDigest md = Constants.newMessageDigest();

        protected int hashRegion(byte[] raw, int ptr, int end) {
            this.md.reset();
            this.md.update(raw, ptr, end - ptr);
            return NB.decodeInt32((byte[])this.md.digest(), (int)0);
        }
    };
    final Hash djb = new Hash(){

        protected int hashRegion(byte[] raw, int ptr, int end) {
            int hash = 5381;
            while (ptr < end) {
                hash = (hash << 5) + hash + (raw[ptr] & 0xFF);
                ++ptr;
            }
            return hash;
        }
    };
    final Hash string_hash31 = new Hash(){

        protected int hashRegion(byte[] raw, int ptr, int end) {
            int hash = 0;
            while (ptr < end) {
                hash = 31 * hash + (raw[ptr] & 0xFF);
                ++ptr;
            }
            return hash;
        }
    };
    final Hash rabin_DeltaIndex = new Hash(){
        private final byte[] buf16 = new byte[16];
        private final int[] T = new int[]{0, -725175507, 2102121847, -1450351014, 777066947, -90723602, 1394265268, -2015592551, 1554133894, -2006679381, 568977137, -181447204, 1928538693, -1506436760, 263782194, -612479969, 1837290529, -1186699508, 281608534, -1005604229, 1137954274, -1760198961, 1050155157, -362894408, 824240039, -437889910, 1282093776, -1733459459, 527564388, -877179575, 1647979283, -1224959938, 264444783, -620386238, 1921568280, -1504805579, 563217068, -178998911, 1557780443, -2011208458, 1398876393, -2019058748, 774569374, -85176653, 2100310314, -1443462649, 8119389, -725788816, 1648480078, -1232634781, 520755769, -875779820, 1276171917, -1730779744, 828048378, -442650409, 1055128776, -366653467, 1135094207, -1754359150, 280159499, -999008730, 1845047420, -1187019951, 528889566, -884963853, 1657660329, -1240772476, 836185885, -451830736, 1285356138, -1738913465, 1126434136, -1746749835, 1047515183, -357997822, 1836391579, -1179406410, 272550380, -990348607, 1912922879, -1497214510, 256849800, -611744603, 1549138748, -2003613679, 555626059, -170353306, 782684537, -94346668, 1408041998, -2027178205, 16238778, -734954601, 2109480397, -1451577632, 272969137, -998007140, 1829697734, -1178055701, 1041511538, -355301537, 1130356997, -1751559640, 1290214967, -1742623462, 833407808, -446007187, 1656096756, -1234127655, 536728195, -885300818, 2110257552, -1459533123, 9186535, -733306934, 1402396755, -2024778882, 786248996, -98859511, 560318998, -173835973, 1546526561, -1998017460, 255120341, -604872456, 1920927394, -1497778801, 1057779132, -339026287, 1111996619, -1769927706, 291337343, -979646638, 1813422344, -1194323419, 1672371770, -1217860329, 518359885, -903661472, 1308575737, -1724255020, 817140366, -462282333, 1385085341, -2042099024, 801467626, -83632185, 2095030366, -1474751629, 26506537, -715995644, 237799963, -622184138, 1936154476, -1482560447, 545100760, -189062923, 1563838127, -1980697214, 818902739, -469121538, 1300538276, -1723723639, 513699600, -900146115, 1674951271, -1223489206, 1819100501, -1196689800, 287739938, -975166705, 1111252118, -1761939525, 1064798689, -340706612, 1565369074, -1987374625, 537294725, -188693336, 1931262769, -1478883300, 240610886, -627974805, 32477556, -718724519, 2091140099, -1469909202, 801015991, -76006502, 1391812032, -2043416851, 545938274, -196286385, 1572965909, -1996014280, 249250465, -635571828, 1938855894, -1487526661, 2083023076, -1460741175, 23313811, -710603074, 1383690535, -2034253302, 791848016, -67889283, 1292406595, -1714537362, 809720372, -460986087, 1666815616, -1214306899, 504513527, -892014374, 296402117, -982773784, 1826711986, -1205347681, 1073456390, -348318165, 1118859377, -1770601636, 793329677, -74452192, 1375901050, -2033965481, 18373070, -706811165, 2085850297, -1466613868, 1944810379, -1490173786, 245409532, -630843951, 1572497992, -1988306587, 552714047, -197719022, 1120637996, -1777522943, 1065369947, -347671946, 1822068207, -1201914174, 298932376, -988288075, 510240682, -894495609, 1663202013, -1209744912, 809025129, -453112508, 1299409694, -1716135885};

        protected int hashRegion(byte[] raw, int ptr, int end) {
            if (end - ptr < 16) {
                Arrays.fill(this.buf16, (byte)0);
                System.arraycopy(raw, ptr, this.buf16, 0, end - ptr);
                return this.rabin(this.buf16, 0);
            }
            return this.rabin(raw, ptr);
        }

        private int rabin(byte[] raw, int ptr) {
            int hash = (raw[ptr] & 0xFF) << 24 | (raw[ptr + 1] & 0xFF) << 16 | (raw[ptr + 2] & 0xFF) << 8 | raw[ptr + 3] & 0xFF;
            hash ^= this.T[hash >>> 31];
            hash = (hash << 8 | raw[ptr + 4] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 5] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 6] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 7] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 8] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 9] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 10] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 11] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 12] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 13] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 14] & 0xFF) ^ this.T[hash >>> 23];
            hash = (hash << 8 | raw[ptr + 15] & 0xFF) ^ this.T[hash >>> 23];
            return hash;
        }
    };
    final Fold truncate = new Fold(){

        public int fold(int hash, int bits) {
            return hash & (1 << bits) - 1;
        }
    };
    final Fold golden_ratio = new Fold(){

        public int fold(int hash, int bits) {
            return hash * -1640562687 >>> 32 - bits;
        }
    };
    @Option(name="--hash", multiValued=true, metaVar="NAME", usage="Enable hash function(s)")
    List<String> hashFunctions = new ArrayList<String>();
    @Option(name="--fold", multiValued=true, metaVar="NAME", usage="Enable fold function(s)")
    List<String> foldFunctions = new ArrayList<String>();
    @Option(name="--text-limit", metaVar="LIMIT", usage="Maximum size in KiB to scan")
    int textLimit = 15360;
    @Option(name="--repository", aliases={"-r"}, multiValued=true, metaVar="GIT_DIR", usage="Repository to scan")
    List<File> gitDirs = new ArrayList<File>();

    TextHashFunctions() {
    }

    @Override
    protected boolean requiresRepository() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws Exception {
        if (this.gitDirs.isEmpty()) {
            RepositoryBuilder rb = (RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(new File(this.gitdir))).readEnvironment()).findGitDir();
            if (rb.getGitDir() == null) {
                throw TextHashFunctions.die(CLIText.get().cantFindGitDirectory);
            }
            this.gitDirs.add(rb.getGitDir());
        }
        for (File dir : this.gitDirs) {
            RepositoryBuilder rb = new RepositoryBuilder();
            if (RepositoryCache.FileKey.isGitRepository((File)dir, (FS)FS.DETECTED)) {
                rb.setGitDir(dir);
            } else {
                rb.findGitDir(dir);
            }
            Repository db = rb.build();
            try {
                this.run(db);
            }
            finally {
                db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Repository db) throws Exception {
        List<Function> all = this.init();
        long fileCnt = 0L;
        long lineCnt = 0L;
        ObjectReader or = db.newObjectReader();
        try {
            MutableObjectId id = new MutableObjectId();
            RevWalk rw = new RevWalk(or);
            TreeWalk tw = new TreeWalk(or);
            tw.reset((AnyObjectId)rw.parseTree((AnyObjectId)db.resolve("HEAD")));
            tw.setRecursive(true);
            while (tw.next()) {
                byte[] raw;
                FileMode fm = tw.getFileMode(0);
                if (!FileMode.REGULAR_FILE.equals(fm) && !FileMode.EXECUTABLE_FILE.equals(fm)) continue;
                try {
                    tw.getObjectId(id, 0);
                    raw = or.open((AnyObjectId)id).getCachedBytes(this.textLimit * 1024);
                }
                catch (LargeObjectException tooBig) {
                    continue;
                }
                if (RawText.isBinary((byte[])raw)) continue;
                RawText txt = new RawText(raw);
                int[] lines = new int[txt.size()];
                int cnt = 0;
                HashSet<Line> u = new HashSet<Line>();
                for (int i = 0; i < txt.size(); ++i) {
                    if (!u.add(new Line(txt, i))) continue;
                    lines[cnt++] = i;
                }
                ++fileCnt;
                lineCnt += (long)cnt;
                for (Function fun : all) {
                    TextHashFunctions.testOne(fun, txt, lines, cnt);
                }
            }
        }
        finally {
            or.release();
        }
        if (db.getDirectory() != null) {
            String name = db.getDirectory().getName();
            File parent = db.getDirectory().getParentFile();
            if (name.equals(".git") && parent != null) {
                name = parent.getName();
            }
            this.outw.println(name + ":");
        }
        this.outw.format("  %6d files; %5d avg. unique lines/file\n", new Object[]{fileCnt, lineCnt / fileCnt});
        this.outw.format("%-20s %-15s %9s\n", new Object[]{"Hash", "Fold", "Max Len"});
        this.outw.println("-----------------------------------------------");
        String lastHashName = null;
        for (Function fun : all) {
            String hashName = fun.hash.name;
            if (hashName.equals(lastHashName)) {
                hashName = "";
            }
            this.outw.format("%-20s %-15s %9d\n", new Object[]{hashName, fun.fold.name, fun.maxChainLength});
            lastHashName = fun.hash.name;
        }
        this.outw.println();
        this.outw.flush();
    }

    private static void testOne(Function fun, RawText txt, int[] elements, int cnt) {
        Hash cmp = fun.hash;
        Fold fold = fun.fold;
        int bits = TextHashFunctions.tableBits(cnt);
        int[] buckets = new int[1 << bits];
        for (int i = 0; i < cnt; ++i) {
            int n = fold.fold(cmp.hash(txt, elements[i]), bits);
            buckets[n] = buckets[n] + 1;
        }
        int maxChainLength = 0;
        for (int i = 0; i < buckets.length; ++i) {
            maxChainLength = Math.max(maxChainLength, buckets[i]);
        }
        fun.maxChainLength = Math.max(fun.maxChainLength, maxChainLength);
    }

    private List<Function> init() {
        ArrayList<Hash> hashes = new ArrayList<Hash>();
        ArrayList<Fold> folds = new ArrayList<Fold>();
        try {
            for (Field f : TextHashFunctions.class.getDeclaredFields()) {
                if (f.getType() == Hash.class) {
                    f.setAccessible(true);
                    Hash cmp = (Hash)((Object)f.get(this));
                    cmp.name = f.getName();
                    hashes.add(cmp);
                    continue;
                }
                if (f.getType() != Fold.class) continue;
                f.setAccessible(true);
                Fold fold = (Fold)f.get(this);
                fold.name = f.getName();
                folds.add(fold);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Cannot determine names", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot determine names", e);
        }
        ArrayList<Function> all = new ArrayList<Function>();
        for (Hash cmp : hashes) {
            if (!TextHashFunctions.include(cmp.name, this.hashFunctions)) continue;
            for (Fold f : folds) {
                if (!TextHashFunctions.include(f.name, this.foldFunctions)) continue;
                all.add(new Function(cmp, f));
            }
        }
        return all;
    }

    private static boolean include(String name, List<String> want) {
        if (want.isEmpty()) {
            return true;
        }
        for (String s : want) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private static int tableBits(int sz) {
        int bits = 31 - Integer.numberOfLeadingZeros(sz);
        if (bits == 0) {
            bits = 1;
        }
        if (1 << bits < sz) {
            ++bits;
        }
        return bits;
    }

    private class Line {
        private final RawText txt;
        private final int pos;

        Line(RawText txt, int pos) {
            this.txt = txt;
            this.pos = pos;
        }

        public int hashCode() {
            return RawTextComparator.DEFAULT.hash(this.txt, this.pos);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Line) {
                Line e = (Line)obj;
                return RawTextComparator.DEFAULT.equals((Sequence)this.txt, this.pos, (Sequence)e.txt, e.pos);
            }
            return false;
        }
    }

    private static abstract class Fold {
        String name;

        private Fold() {
        }

        abstract int fold(int var1, int var2);
    }

    private static abstract class Hash
    extends RawTextComparator {
        String name;

        private Hash() {
        }

        public boolean equals(RawText a, int ai, RawText b, int bi) {
            return RawTextComparator.DEFAULT.equals((Sequence)a, ai, (Sequence)b, bi);
        }
    }

    private static class Function {
        final Hash hash;
        final Fold fold;
        int maxChainLength;

        Function(Hash cmp, Fold fold) {
            this.hash = cmp;
            this.fold = fold;
        }
    }
}

