/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.BufferedWriter;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Die;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.CmdLineParser;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.io.ThrowingPrintWriter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

public abstract class TextBuiltin {
    private String commandName;
    @Option(name="--help", usage="usage_displayThisHelpText", aliases={"-h"})
    private boolean help;
    protected InputStream ins;
    protected ThrowingPrintWriter outw;
    protected OutputStream outs;
    @Deprecated
    protected PrintWriter out;
    protected ThrowingPrintWriter errw;
    protected OutputStream errs;
    protected Repository db;
    protected String gitdir;
    protected RevWalk argWalk;

    final void setCommandName(String name) {
        this.commandName = name;
    }

    protected boolean requiresRepository() {
        return true;
    }

    protected void init(Repository repository, String gitDir) {
        try {
            String outputEncoding;
            String string = outputEncoding = repository != null ? repository.getConfig().getString("i18n", null, "logOutputEncoding") : null;
            if (this.ins == null) {
                this.ins = new FileInputStream(FileDescriptor.in);
            }
            if (this.outs == null) {
                this.outs = new FileOutputStream(FileDescriptor.out);
            }
            if (this.errs == null) {
                this.errs = new FileOutputStream(FileDescriptor.err);
            }
            BufferedWriter outbufw = outputEncoding != null ? new BufferedWriter(new OutputStreamWriter(this.outs, outputEncoding)) : new BufferedWriter(new OutputStreamWriter(this.outs));
            this.out = new PrintWriter(outbufw);
            this.outw = new ThrowingPrintWriter((Writer)outbufw);
            BufferedWriter errbufw = outputEncoding != null ? new BufferedWriter(new OutputStreamWriter(this.errs, outputEncoding)) : new BufferedWriter(new OutputStreamWriter(this.errs));
            this.errw = new ThrowingPrintWriter((Writer)errbufw);
        }
        catch (IOException e) {
            throw TextBuiltin.die(CLIText.get().cannotCreateOutputStream);
        }
        if (repository != null && repository.getDirectory() != null) {
            this.db = repository;
            this.gitdir = repository.getDirectory().getAbsolutePath();
        } else {
            this.db = repository;
            this.gitdir = gitDir;
        }
    }

    public final void execute(String[] args) throws Exception {
        this.parseArguments(args);
        this.run();
    }

    protected void parseArguments(String[] args) throws IOException {
        CmdLineParser clp;
        block3: {
            clp = new CmdLineParser(this);
            try {
                clp.parseArgument(args);
            }
            catch (CmdLineException err) {
                if (this.help) break block3;
                this.errw.println(MessageFormat.format(CLIText.get().fatalError, err.getMessage()));
                throw TextBuiltin.die(true);
            }
        }
        if (this.help) {
            this.printUsageAndExit(clp);
        }
        this.argWalk = clp.getRevWalkGently();
    }

    public void printUsageAndExit(CmdLineParser clp) throws IOException {
        this.printUsageAndExit("", clp);
    }

    public void printUsageAndExit(String message, CmdLineParser clp) throws IOException {
        this.errw.println(message);
        this.errw.print((Object)"jgit ");
        this.errw.print((Object)this.commandName);
        clp.printSingleLineUsage((Writer)this.errw, this.getResourceBundle());
        this.errw.println();
        this.errw.println();
        clp.printUsage((Writer)this.errw, this.getResourceBundle());
        this.errw.println();
        this.errw.flush();
        throw TextBuiltin.die(true);
    }

    protected ResourceBundle getResourceBundle() {
        return CLIText.get().resourceBundle();
    }

    protected abstract void run() throws Exception;

    public Repository getRepository() {
        return this.db;
    }

    ObjectId resolve(String s) throws IOException {
        ObjectId r = this.db.resolve(s);
        if (r == null) {
            throw TextBuiltin.die(MessageFormat.format(CLIText.get().notARevision, s));
        }
        return r;
    }

    protected static Die die(String why) {
        return new Die(why);
    }

    protected static Die die(String why, Throwable cause) {
        return new Die(why, cause);
    }

    protected static Die die(boolean aborted) {
        return new Die(aborted);
    }

    String abbreviateRef(String dst, boolean abbreviateRemote) {
        if (dst.startsWith("refs/heads/")) {
            dst = dst.substring("refs/heads/".length());
        } else if (dst.startsWith("refs/tags/")) {
            dst = dst.substring("refs/tags/".length());
        } else if (abbreviateRemote && dst.startsWith("refs/remotes/")) {
            dst = dst.substring("refs/remotes/".length());
        }
        return dst;
    }
}

