/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_CreateATag")
class Tag
extends TextBuiltin {
    @Option(name="-f", usage="usage_forceReplacingAnExistingTag")
    private boolean force;
    @Option(name="-m", metaVar="metaVar_message", usage="usage_tagMessage")
    private String message = "";
    @Argument(index=0, required=true, metaVar="metaVar_name")
    private String tagName;
    @Argument(index=1, metaVar="metaVar_object")
    private ObjectId object;

    Tag() {
    }

    protected void run() throws Exception {
        Git git = new Git(this.db);
        TagCommand command = git.tag().setForceUpdate(this.force).setMessage(this.message).setName(this.tagName);
        if (this.object != null) {
            RevWalk walk = new RevWalk(this.db);
            command.setObjectId(walk.parseAny((AnyObjectId)this.object));
        }
        command.call();
    }
}

