/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

class LsTree
extends TextBuiltin {
    @Option(name="--recursive", usage="usage_recurseIntoSubtrees", aliases={"-r"})
    private boolean recursive;
    @Argument(index=0, required=true, metaVar="metaVar_treeish")
    private AbstractTreeIterator tree;

    LsTree() {
    }

    protected void run() throws Exception {
        TreeWalk walk = new TreeWalk(this.db);
        walk.setRecursive(this.recursive);
        walk.addTree(this.tree);
        while (walk.next()) {
            FileMode mode = walk.getFileMode(0);
            if (mode == FileMode.TREE) {
                this.out.print('0');
            }
            this.out.print(mode);
            this.out.print(' ');
            this.out.print(Constants.typeString((int)mode.getObjectType()));
            this.out.print(' ');
            this.out.print(walk.getObjectId(0).name());
            this.out.print('\t');
            this.out.print(walk.getPathString());
            this.out.println();
        }
    }
}

