/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.AbstractFetchCommand;
import org.eclipse.jgit.pgm.CLIText;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_cloneRepositoryIntoNewDir")
class Clone
extends AbstractFetchCommand {
    @Option(name="--origin", aliases={"-o"}, metaVar="metaVar_remoteName", usage="usage_useNameInsteadOfOriginToTrackUpstream")
    private String remoteName = "origin";
    @Argument(index=0, required=true, metaVar="metaVar_uriish")
    private String sourceUri;
    @Argument(index=1, metaVar="metaVar_directory")
    private String localName;
    private FileRepository dst;

    Clone() {
    }

    protected final boolean requiresRepository() {
        return false;
    }

    protected void run() throws Exception {
        if (this.localName != null && this.gitdir != null) {
            throw Clone.die(CLIText.get().conflictingUsageOf_git_dir_andArguments);
        }
        URIish uri = new URIish(this.sourceUri);
        if (this.localName == null) {
            try {
                this.localName = uri.getHumanishName();
            }
            catch (IllegalArgumentException e) {
                throw Clone.die(MessageFormat.format(CLIText.get().cannotGuessLocalNameFrom, this.sourceUri));
            }
        }
        if (this.gitdir == null) {
            this.gitdir = new File(this.localName, ".git").getAbsolutePath();
        }
        this.dst = new FileRepository(this.gitdir);
        this.dst.create();
        FileBasedConfig dstcfg = this.dst.getConfig();
        dstcfg.setBoolean("core", null, "bare", false);
        dstcfg.save();
        this.db = this.dst;
        this.out.print(MessageFormat.format(CLIText.get().initializedEmptyGitRepositoryIn, this.gitdir));
        this.out.println();
        this.out.flush();
        this.saveRemote(uri);
        FetchResult r = this.runFetch();
        Ref branch = this.guessHEAD(r);
        this.doCheckout(branch);
    }

    private void saveRemote(URIish uri) throws URISyntaxException, IOException {
        FileBasedConfig dstcfg = this.dst.getConfig();
        RemoteConfig rc = new RemoteConfig((Config)dstcfg, this.remoteName);
        rc.addURI(uri);
        rc.addFetchRefSpec(new RefSpec().setForceUpdate(true).setSourceDestination("refs/heads/*", "refs/remotes/" + this.remoteName + "/*"));
        rc.update((Config)dstcfg);
        dstcfg.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FetchResult runFetch() throws NotSupportedException, URISyntaxException, TransportException {
        FetchResult r;
        Transport tn = Transport.open((Repository)this.db, (String)this.remoteName);
        try {
            tn.setTagOpt(TagOpt.FETCH_TAGS);
            r = tn.fetch((ProgressMonitor)new TextProgressMonitor(), null);
        }
        finally {
            tn.close();
        }
        this.showFetchResult(r);
        return r;
    }

    private Ref guessHEAD(FetchResult result) {
        Ref idHEAD = result.getAdvertisedRef("HEAD");
        ArrayList<Ref> availableRefs = new ArrayList<Ref>();
        Ref head = null;
        for (Ref r : result.getAdvertisedRefs()) {
            String n = r.getName();
            if (!n.startsWith("refs/heads/")) continue;
            availableRefs.add(r);
            if (idHEAD == null || head != null || !r.getObjectId().equals((AnyObjectId)idHEAD.getObjectId())) continue;
            head = r;
        }
        Collections.sort(availableRefs, RefComparator.INSTANCE);
        if (idHEAD != null && head == null) {
            head = idHEAD;
        }
        return head;
    }

    private void doCheckout(Ref branch) throws IOException {
        if (branch == null) {
            throw Clone.die(CLIText.get().cannotChekoutNoHeadsAdvertisedByRemote);
        }
        if (!"HEAD".equals(branch.getName())) {
            RefUpdate u = this.db.updateRef("HEAD");
            u.disableRefLog();
            u.link(branch.getName());
        }
        RevCommit commit = this.parseCommit(branch);
        RefUpdate u = this.db.updateRef("HEAD");
        u.setNewObjectId((AnyObjectId)commit);
        u.forceUpdate();
        DirCache dc = this.db.lockDirCache();
        DirCacheCheckout co = new DirCacheCheckout(this.db, dc, (ObjectId)commit.getTree());
        co.checkout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevCommit parseCommit(Ref branch) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit commit;
        RevWalk rw = new RevWalk(this.db);
        try {
            commit = rw.parseCommit((AnyObjectId)branch.getObjectId());
        }
        finally {
            rw.release();
        }
        return commit;
    }
}

