/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class SeparateClassloaderTestRunner
extends BlockJUnit4ClassRunner {
    public SeparateClassloaderTestRunner(Class<?> klass) throws InitializationError {
        super(SeparateClassloaderTestRunner.loadNewClass(klass));
    }

    private static Class<?> loadNewClass(Class<?> klass) throws InitializationError {
        try {
            String pathSeparator = System.getProperty("path.separator");
            String[] classPathEntries = System.getProperty("java.class.path").split(pathSeparator);
            URL[] urls = new URL[classPathEntries.length];
            int i = 0;
            while (i < classPathEntries.length) {
                urls[i] = Paths.get(classPathEntries[i], new String[0]).toUri().toURL();
                ++i;
            }
            URLClassLoader testClassLoader = new URLClassLoader(urls){

                @Override
                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    if (name.startsWith("org.eclipse.jgit.")) {
                        return super.findClass(name);
                    }
                    return super.loadClass(name);
                }
            };
            return Class.forName(klass.getName(), true, testClassLoader);
        }
        catch (ClassNotFoundException | MalformedURLException e) {
            throw new InitializationError((Throwable)e);
        }
    }
}

