/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.junit.Assert;
import org.junit.Test;

public abstract class JGitTestUtil {
    public static final String CLASSPATH_TO_RESOURCES = "org/eclipse/jgit/test/resources/";

    private JGitTestUtil() {
        throw new UnsupportedOperationException();
    }

    public static String getName() {
        try {
            throw new GatherStackTrace();
        }
        catch (GatherStackTrace wanted) {
            GatherStackTrace stack = wanted;
            try {
                for (StackTraceElement stackTrace : stack.getStackTrace()) {
                    Method method;
                    String className = stackTrace.getClassName();
                    String methodName = stackTrace.getMethodName();
                    try {
                        method = Class.forName(className).getMethod(methodName, null);
                    }
                    catch (NoSuchMethodException e) {
                        continue;
                    }
                    Test annotation = method.getAnnotation(Test.class);
                    if (annotation == null) continue;
                    return methodName;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            throw new AssertionError((Object)"Cannot determine name of current test");
        }
    }

    public static void assertEquals(byte[] exp, byte[] act) {
        Assert.assertEquals((Object)JGitTestUtil.s(exp), (Object)JGitTestUtil.s(act));
    }

    private static String s(byte[] raw) {
        return RawParseUtils.decode((byte[])raw);
    }

    public static File getTestResourceFile(String fileName) {
        if (fileName == null || fileName.length() <= 0) {
            return null;
        }
        URL url = JGitTestUtil.cl().getResource(CLASSPATH_TO_RESOURCES + fileName);
        if (url == null) {
            return new File("tst", fileName);
        }
        if ("jar".equals(url.getProtocol())) {
            try {
                File tmp = File.createTempFile("tmp_", "_" + fileName);
                JGitTestUtil.copyTestResource(fileName, tmp);
                return tmp;
            }
            catch (IOException err) {
                throw new RuntimeException("Cannot create temporary file", err);
            }
        }
        try {
            return new File(url.toURI());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + " " + url);
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyTestResource(String name, File dest) throws IOException {
        URL url = JGitTestUtil.cl().getResource(CLASSPATH_TO_RESOURCES + name);
        if (url == null) {
            throw new FileNotFoundException(name);
        }
        InputStream in = url.openStream();
        try {
            FileOutputStream out = new FileOutputStream(dest);
            try {
                int n;
                byte[] buf = new byte[4096];
                while ((n = in.read(buf)) > 0) {
                    out.write(buf, 0, n);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    private static ClassLoader cl() {
        return JGitTestUtil.class.getClassLoader();
    }

    public static File writeTrashFile(Repository db, String name, String data) throws IOException {
        File path = new File(db.getWorkTree(), name);
        JGitTestUtil.write(path, data);
        return path;
    }

    public static File writeTrashFile(Repository db, String subdir, String name, String data) throws IOException {
        File path = new File(db.getWorkTree() + "/" + subdir, name);
        JGitTestUtil.write(path, data);
        return path;
    }

    public static void write(File f, String body) throws IOException {
        FileUtils.mkdirs((File)f.getParentFile(), (boolean)true);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
        try {
            w.write(body);
        }
        finally {
            ((Writer)w).close();
        }
    }

    public static String read(File file) throws IOException {
        byte[] body = IO.readFully((File)file);
        return new String(body, 0, body.length, "UTF-8");
    }

    public static String read(Repository db, String name) throws IOException {
        File file = new File(db.getWorkTree(), name);
        return JGitTestUtil.read(file);
    }

    public static boolean check(Repository db, String name) {
        File file = new File(db.getWorkTree(), name);
        return file.exists();
    }

    public static void deleteTrashFile(Repository db, String name) throws IOException {
        File path = new File(db.getWorkTree(), name);
        FileUtils.delete((File)path);
    }

    private static class GatherStackTrace
    extends Exception {
        private GatherStackTrace() {
        }
    }
}

