/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.http;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Fields;

public class AccessEvent {
    private final String method;
    private final HttpURI uri;
    private final Map<String, String> requestHeaders;
    private final Map<String, String[]> parameters;
    private int status;
    private Map<String, String> responseHeaders;

    AccessEvent(Request req) {
        this.method = req.getMethod();
        this.uri = req.getHttpURI();
        this.requestHeaders = AccessEvent.cloneHeaders(req);
        this.parameters = AccessEvent.cloneParameters(req);
    }

    void setResponse(Response rsp) {
        this.status = rsp.getStatus();
        this.responseHeaders = AccessEvent.cloneHeaders(rsp);
    }

    private static Map<String, String> cloneHeaders(Request req) {
        TreeMap<String, String> r = new TreeMap<String, String>();
        for (HttpField f : req.getHeaders()) {
            String key = f.getName();
            if (r.containsKey(key)) continue;
            r.put(key, f.getValue());
        }
        return Collections.unmodifiableMap(r);
    }

    private static Map<String, String> cloneHeaders(Response rsp) {
        TreeMap<String, String> r = new TreeMap<String, String>();
        for (HttpField f : rsp.getHeaders()) {
            String key = f.getName();
            if (r.containsKey(key)) continue;
            r.put(key, f.getValue());
        }
        return Collections.unmodifiableMap(r);
    }

    private static Map<String, String[]> cloneParameters(Request req) {
        TreeMap<String, String[]> r = new TreeMap<String, String[]>();
        try {
            Fields fields = Request.getParameters((Request)req);
            for (String n : fields.getNames()) {
                r.put(n, fields.getValues(n).toArray(new String[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to extract request parameters", e);
        }
        return r;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public String getRequestHeader(String name) {
        return this.requestHeaders.get(name);
    }

    public String getParameter(String name) {
        String[] r = this.parameters.get(name);
        return r != null && 1 <= r.length ? r[0] : null;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public int getStatus() {
        return this.status;
    }

    public String getResponseHeader(String name) {
        return this.responseHeaders != null ? this.responseHeaders.get(name) : null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.method);
        b.append(' ');
        b.append(this.uri.getPath());
        if (!this.parameters.isEmpty()) {
            b.append('?');
            boolean first = true;
            for (Map.Entry<String, String[]> e : this.parameters.entrySet()) {
                String[] stringArray = e.getValue();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String val = stringArray[n2];
                    if (!first) {
                        b.append('&');
                    }
                    first = false;
                    b.append(e.getKey());
                    b.append('=');
                    b.append(val);
                    ++n2;
                }
            }
        }
        b.append(' ');
        b.append(this.status);
        return b.toString();
    }
}

