/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.HttpServerText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

public final class ServletUtils {
    public static final String ATTRIBUTE_REPOSITORY = "org.eclipse.jgit.Repository";
    public static final String ATTRIBUTE_HANDLER = "org.eclipse.jgit.transport.UploadPackOrReceivePack";

    public static Repository getRepository(ServletRequest req) {
        Repository db = (Repository)req.getAttribute(ATTRIBUTE_REPOSITORY);
        if (db == null) {
            throw new IllegalStateException(HttpServerText.get().expectedRepositoryAttribute);
        }
        return db;
    }

    public static InputStream getInputStream(HttpServletRequest req) throws IOException {
        Object in = req.getInputStream();
        String enc = req.getHeader("Content-Encoding");
        if ("gzip".equals(enc) || "x-gzip".equals(enc)) {
            in = new GZIPInputStream((InputStream)in);
        } else if (enc != null) {
            throw new IOException(MessageFormat.format(HttpServerText.get().encodingNotSupportedByThisLibrary, "Content-Encoding", enc));
        }
        return in;
    }

    public static void consumeRequestBody(HttpServletRequest req) {
        if (0 < req.getContentLength() || ServletUtils.isChunked(req)) {
            try {
                ServletUtils.consumeRequestBody((InputStream)req.getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static boolean isChunked(HttpServletRequest req) {
        return "chunked".equals(req.getHeader("Transfer-Encoding"));
    }

    public static void consumeRequestBody(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            while (0L < in.skip(2048L) || 0 <= in.read()) {
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void sendPlainText(String content, HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        byte[] raw = content.getBytes("UTF-8");
        rsp.setContentType("text/plain");
        rsp.setCharacterEncoding("UTF-8");
        ServletUtils.send(raw, req, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(byte[] content, HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        content = ServletUtils.sendInit(content, req, rsp);
        ServletOutputStream out = rsp.getOutputStream();
        try {
            out.write(content);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    private static byte[] sendInit(byte[] content, HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        rsp.setHeader("ETag", ServletUtils.etag(content));
        if (256 < content.length && ServletUtils.acceptsGzipEncoding(req)) {
            content = ServletUtils.compress(content);
            rsp.setHeader("Content-Encoding", "gzip");
        }
        rsp.setContentLength(content.length);
        return content;
    }

    static boolean acceptsGzipEncoding(HttpServletRequest req) {
        return ServletUtils.acceptsGzipEncoding(req.getHeader("Accept-Encoding"));
    }

    static boolean acceptsGzipEncoding(String accepts) {
        if (accepts == null) {
            return false;
        }
        int b = 0;
        while (b < accepts.length()) {
            int comma = accepts.indexOf(44, b);
            int e = 0 <= comma ? comma : accepts.length();
            String term = accepts.substring(b, e).trim();
            if (term.equals("gzip")) {
                return true;
            }
            b = e + 1;
        }
        return false;
    }

    private static byte[] compress(byte[] raw) throws IOException {
        int maxLen = raw.length + 32;
        ByteArrayOutputStream out = new ByteArrayOutputStream(maxLen);
        GZIPOutputStream gz = new GZIPOutputStream(out);
        gz.write(raw);
        gz.finish();
        gz.flush();
        return out.toByteArray();
    }

    private static String etag(byte[] content) {
        MessageDigest md = Constants.newMessageDigest();
        md.update(content);
        return ObjectId.fromRaw((byte[])md.digest()).getName();
    }

    private ServletUtils() {
    }
}

