/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ant.tasks;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.util.FS;

public class GitAddTask
extends Task {
    private File src;
    private Union path;

    public void setSrc(File src) {
        this.src = src;
    }

    public void addFileset(FileSet set) {
        this.getPath().add((ResourceCollection)set);
    }

    public void addDirset(DirSet set) {
        this.getPath().add((ResourceCollection)set);
    }

    private synchronized Union getPath() {
        if (this.path == null) {
            this.path = new Union();
            this.path.setProject(this.getProject());
        }
        return this.path;
    }

    public void execute() throws BuildException {
        AddCommand gitAdd;
        if (this.src == null) {
            throw new BuildException("Repository path not specified.");
        }
        if (!RepositoryCache.FileKey.isGitRepository((File)new File(this.src, ".git"), (FS)FS.DETECTED)) {
            throw new BuildException("Specified path (" + this.src + ") is not a git repository.");
        }
        try {
            Repository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().readEnvironment()).findGitDir(this.src)).build();
            gitAdd = new Git(repo).add();
        }
        catch (IOException e) {
            throw new BuildException("Could not access repository " + this.src, (Throwable)e);
        }
        try {
            String[] allFiles;
            String prefix = this.src.getCanonicalPath();
            for (String file : allFiles = this.getPath().list()) {
                String toAdd = this.translateFilePathUsingPrefix(file, prefix);
                this.log("Adding " + toAdd, 3);
                gitAdd.addFilepattern(toAdd);
            }
            gitAdd.call();
        }
        catch (Exception e) {
            throw new BuildException("Could not add files to index." + this.src, (Throwable)e);
        }
    }

    private String translateFilePathUsingPrefix(String file, String prefix) throws IOException {
        if (file.equals(prefix)) {
            return ".";
        }
        return new File(file).getCanonicalPath().substring(prefix.length() + 1);
    }
}

