/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;

public abstract class ColumnViewerEditor {
    private CellEditor cellEditor;
    private ICellEditorListener cellEditorListener;
    private FocusListener focusListener;
    private MouseListener mouseListener;
    private ColumnViewer viewer;
    private TraverseListener tabeditingListener;
    private int activationTime;
    private ViewerCell cell;
    private ColumnViewerEditorActivationEvent activationEvent;
    private ListenerList editorActivationListener;
    private ColumnViewerEditorActivationStrategy editorActivationStrategy;
    public static final int DEFAULT = 1;
    public static final int TABBING_MOVE_TO_ROW_NEIGHBOR = 2;
    public static final int TABBING_CYCLE_IN_ROW = 4;
    public static final int TABBING_VERTICAL = 8;
    public static final int TABBING_HORIZONTAL = 16;
    public static final int KEYBOARD_ACTIVATION = 32;
    private int feature;

    protected ColumnViewerEditor(ColumnViewer viewer, ColumnViewerEditorActivationStrategy editorActivationStrategy, int feature) {
        this.viewer = viewer;
        this.editorActivationStrategy = editorActivationStrategy;
        if ((feature & 0x20) == 32) {
            this.editorActivationStrategy.setEnableEditorActivationWithKeyboard(true);
        }
        this.feature = feature;
        this.initCellEditorListener();
    }

    private void initCellEditorListener() {
        this.cellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
                ColumnViewerEditor.this.cancelEditing();
            }

            public void applyEditorValue() {
                ColumnViewerEditor.this.applyEditorValue();
            }
        };
    }

    void activateCellEditor() {
        ViewerColumn part = this.viewer.getViewerColumn(this.cell.getColumnIndex());
        Object element = this.cell.getElement();
        if (part != null && part.getEditingSupport() != null && part.getEditingSupport().canEdit(element)) {
            this.cellEditor = part.getEditingSupport().getCellEditor(element);
            if (this.cellEditor != null) {
                if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                    Object[] ls = this.editorActivationListener.getListeners();
                    int i = 0;
                    while (i < ls.length) {
                        if (this.activationEvent.cancel) {
                            return;
                        }
                        ((ColumnViewerEditorActivationListener)ls[i]).beforeEditorActivated(this.activationEvent);
                        ++i;
                    }
                }
                this.updateFocusCell(this.cell, this.activationEvent);
                this.cellEditor.addListener(this.cellEditorListener);
                part.getEditingSupport().initializeCellEditorValue(this.cellEditor, this.cell);
                final Control control = this.cellEditor.getControl();
                this.cellEditor.activate(this.activationEvent);
                if (control == null) {
                    return;
                }
                this.setLayoutData(this.cellEditor.getLayoutData());
                this.setEditor(control, (Item)this.cell.getItem(), this.cell.getColumnIndex());
                this.cellEditor.setFocus();
                if (this.cellEditor.dependsOnExternalFocusListener()) {
                    if (this.focusListener == null) {
                        this.focusListener = new FocusAdapter(){

                            public void focusLost(FocusEvent e) {
                                ColumnViewerEditor.this.applyEditorValue();
                            }
                        };
                    }
                    control.addFocusListener(this.focusListener);
                }
                this.mouseListener = new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        if (e.time <= ColumnViewerEditor.this.activationTime) {
                            control.removeMouseListener(ColumnViewerEditor.this.mouseListener);
                            ColumnViewerEditor.this.cancelEditing();
                            ColumnViewerEditor.this.handleDoubleClickEvent();
                        } else if (ColumnViewerEditor.this.mouseListener != null) {
                            control.removeMouseListener(ColumnViewerEditor.this.mouseListener);
                        }
                    }
                };
                control.addMouseListener(this.mouseListener);
                if (this.tabeditingListener == null) {
                    this.tabeditingListener = new TraverseListener(){

                        public void keyTraversed(TraverseEvent e) {
                            if ((ColumnViewerEditor.this.feature & 1) != 1) {
                                ColumnViewerEditor.this.processTraverseEvent(ColumnViewerEditor.this.cell.getColumnIndex(), ColumnViewerEditor.this.viewer.getViewerRowFromItem(ColumnViewerEditor.this.cell.getItem()), e);
                            }
                        }
                    };
                }
                control.addTraverseListener(this.tabeditingListener);
                if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                    Object[] ls = this.editorActivationListener.getListeners();
                    int i = 0;
                    while (i < ls.length) {
                        ((ColumnViewerEditorActivationListener)ls[i]).afterEditorActivated(this.activationEvent);
                        ++i;
                    }
                }
            }
        }
    }

    void applyEditorValue() {
        CellEditor c = this.cellEditor;
        if (c != null) {
            ColumnViewerEditorDeactivationEvent tmp = new ColumnViewerEditorDeactivationEvent(this.cell);
            if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                Object[] ls = this.editorActivationListener.getListeners();
                int i = 0;
                while (i < ls.length) {
                    ((ColumnViewerEditorActivationListener)ls[i]).beforeEditorDeactivated(tmp);
                    ++i;
                }
            }
            this.cellEditor = null;
            this.activationEvent = null;
            Item t = (Item)this.cell.getItem();
            if (t != null && !t.isDisposed()) {
                this.saveEditorValue(c);
            }
            this.setEditor(null, null, 0);
            c.removeListener(this.cellEditorListener);
            Control control = c.getControl();
            if (control != null) {
                if (this.mouseListener != null) {
                    control.removeMouseListener(this.mouseListener);
                    this.mouseListener = null;
                }
                if (this.focusListener != null) {
                    control.removeFocusListener(this.focusListener);
                }
                if (this.tabeditingListener != null) {
                    control.removeTraverseListener(this.tabeditingListener);
                }
            }
            c.deactivate();
            if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                Object[] ls = this.editorActivationListener.getListeners();
                int i = 0;
                while (i < ls.length) {
                    ((ColumnViewerEditorActivationListener)ls[i]).afterEditorDeactivated(tmp);
                    ++i;
                }
            }
        }
    }

    void cancelEditing() {
        if (this.cellEditor != null) {
            ColumnViewerEditorDeactivationEvent tmp = new ColumnViewerEditorDeactivationEvent(this.cell);
            if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                Object[] ls = this.editorActivationListener.getListeners();
                int i = 0;
                while (i < ls.length) {
                    ((ColumnViewerEditorActivationListener)ls[i]).beforeEditorDeactivated(tmp);
                    ++i;
                }
            }
            this.setEditor(null, null, 0);
            this.cellEditor.removeListener(this.cellEditorListener);
            Control control = this.cellEditor.getControl();
            if (control != null) {
                if (this.mouseListener != null) {
                    control.removeMouseListener(this.mouseListener);
                    this.mouseListener = null;
                }
                if (this.focusListener != null) {
                    control.removeFocusListener(this.focusListener);
                }
                if (this.tabeditingListener != null) {
                    control.removeTraverseListener(this.tabeditingListener);
                }
            }
            CellEditor oldEditor = this.cellEditor;
            this.cellEditor = null;
            this.activationEvent = null;
            oldEditor.deactivate();
            if (this.editorActivationListener != null && !this.editorActivationListener.isEmpty()) {
                Object[] ls = this.editorActivationListener.getListeners();
                int i = 0;
                while (i < ls.length) {
                    ((ColumnViewerEditorActivationListener)ls[i]).afterEditorDeactivated(tmp);
                    ++i;
                }
            }
        }
    }

    void handleEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
        if (this.editorActivationStrategy.isEditorActivationEvent(event)) {
            if (this.cellEditor != null) {
                this.applyEditorValue();
            }
            this.cell = (ViewerCell)event.getSource();
            this.activationEvent = event;
            this.activationTime = event.time + Display.getCurrent().getDoubleClickTime();
            this.activateCellEditor();
        }
    }

    private void saveEditorValue(CellEditor cellEditor) {
        ViewerColumn part = this.viewer.getViewerColumn(this.cell.getColumnIndex());
        if (part != null && part.getEditingSupport() != null) {
            part.getEditingSupport().saveCellEditorValue(cellEditor, this.cell);
        }
    }

    boolean isCellEditorActive() {
        return this.cellEditor != null;
    }

    void handleDoubleClickEvent() {
        this.viewer.fireDoubleClick(new DoubleClickEvent(this.viewer, this.viewer.getSelection()));
        this.viewer.fireOpen(new OpenEvent(this.viewer, this.viewer.getSelection()));
    }

    public void addEditorActivationListener(ColumnViewerEditorActivationListener listener) {
        if (this.editorActivationListener == null) {
            this.editorActivationListener = new ListenerList();
        }
        this.editorActivationListener.add((Object)listener);
    }

    public void removeEditorActivationListener(ColumnViewerEditorActivationListener listener) {
        if (this.editorActivationListener != null) {
            this.editorActivationListener.remove((Object)listener);
        }
    }

    protected void processTraverseEvent(int columnIndex, ViewerRow row, TraverseEvent event) {
        ViewerCell cell2edit = null;
        if (event.detail == 8) {
            event.doit = false;
            if ((event.stateMask & 0x40000) == 262144 && (this.feature & 8) == 8) {
                cell2edit = this.searchCellAboveBelow(row, this.viewer, columnIndex, true);
            } else if ((this.feature & 0x10) == 16) {
                cell2edit = this.searchPreviousCell(row, this.viewer, columnIndex, columnIndex);
            }
        } else if (event.detail == 16) {
            event.doit = false;
            if ((event.stateMask & 0x40000) == 262144 && (this.feature & 8) == 8) {
                cell2edit = this.searchCellAboveBelow(row, this.viewer, columnIndex, false);
            } else if ((this.feature & 0x10) == 16) {
                cell2edit = this.searchNextCell(row, this.viewer, columnIndex, columnIndex);
            }
        }
        if (cell2edit != null) {
            this.viewer.getControl().setRedraw(false);
            ColumnViewerEditorActivationEvent acEvent = new ColumnViewerEditorActivationEvent(cell2edit, event);
            this.viewer.triggerEditorActivationEvent(acEvent);
            this.viewer.getControl().setRedraw(true);
        }
    }

    private ViewerCell searchCellAboveBelow(ViewerRow row, ColumnViewer viewer, int columnIndex, boolean above) {
        ViewerCell rv = null;
        ViewerRow newRow = null;
        newRow = above ? row.getNeighbor(1, false) : row.getNeighbor(2, false);
        if (newRow != null) {
            ViewerColumn column = viewer.getViewerColumn(columnIndex);
            rv = column != null && column.getEditingSupport() != null && column.getEditingSupport().canEdit(newRow.getItem().getData()) ? newRow.getCell(columnIndex) : this.searchCellAboveBelow(newRow, viewer, columnIndex, above);
        }
        return rv;
    }

    private ViewerCell searchPreviousCell(ViewerRow row, ColumnViewer viewer, int columnIndex, int startIndex) {
        ViewerRow rowAbove;
        ViewerCell rv = null;
        if (columnIndex - 1 >= 0) {
            ViewerColumn column = viewer.getViewerColumn(columnIndex - 1);
            rv = column != null && column.getEditingSupport() != null && column.getEditingSupport().canEdit(row.getItem().getData()) ? row.getCell(columnIndex - 1) : this.searchPreviousCell(row, viewer, columnIndex - 1, startIndex);
        } else if ((this.feature & 4) == 4) {
            if (columnIndex - 1 != startIndex) {
                rv = this.searchPreviousCell(row, viewer, row.getColumnCount(), startIndex);
            }
        } else if ((this.feature & 2) == 2 && (rowAbove = row.getNeighbor(1, false)) != null) {
            rv = this.searchPreviousCell(rowAbove, viewer, rowAbove.getColumnCount(), startIndex);
        }
        return rv;
    }

    private ViewerCell searchNextCell(ViewerRow row, ColumnViewer viewer, int columnIndex, int startIndex) {
        ViewerRow rowBelow;
        ViewerCell rv = null;
        if (columnIndex + 1 < row.getColumnCount()) {
            ViewerColumn column = viewer.getViewerColumn(columnIndex + 1);
            rv = column != null && column.getEditingSupport() != null && column.getEditingSupport().canEdit(row.getItem().getData()) ? row.getCell(columnIndex + 1) : this.searchNextCell(row, viewer, columnIndex + 1, startIndex);
        } else if ((this.feature & 4) == 4) {
            if (columnIndex + 1 != startIndex) {
                rv = this.searchNextCell(row, viewer, -1, startIndex);
            }
        } else if ((this.feature & 2) == 2 && (rowBelow = row.getNeighbor(2, false)) != null) {
            rv = this.searchNextCell(rowBelow, viewer, -1, startIndex);
        }
        return rv;
    }

    protected abstract void setEditor(Control var1, Item var2, int var3);

    protected abstract void setLayoutData(CellEditor.LayoutData var1);

    protected abstract void updateFocusCell(ViewerCell var1, ColumnViewerEditorActivationEvent var2);

    public ViewerCell getFocusCell() {
        return null;
    }

    protected ColumnViewer getViewer() {
        return this.viewer;
    }
}

