/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.util.server;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.EnumSet;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.eclipse.jetty.websocket.util.server.internal.WebSocketMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="WebSocket Upgrade Filter")
public class WebSocketUpgradeFilter
implements Filter,
Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketUpgradeFilter.class);
    public static final String MAPPING_ATTRIBUTE_INIT_PARAM = "org.eclipse.jetty.websocket.util.server.internal.WebSocketMapping.key";
    private final Configuration.ConfigurationCustomizer defaultCustomizer = new Configuration.ConfigurationCustomizer();
    private WebSocketMapping mapping;

    private static FilterHolder getFilter(ServletContext servletContext) {
        ServletHandler servletHandler = (ServletHandler)ContextHandler.getContextHandler((ServletContext)servletContext).getChildHandlerByClass(ServletHandler.class);
        for (FilterHolder holder : servletHandler.getFilters()) {
            if (holder.getInitParameter(MAPPING_ATTRIBUTE_INIT_PARAM) == null) continue;
            return holder;
        }
        return null;
    }

    public static FilterHolder ensureFilter(ServletContext servletContext) {
        FilterHolder existingFilter = WebSocketUpgradeFilter.getFilter(servletContext);
        if (existingFilter != null) {
            return existingFilter;
        }
        String name = "WebSocketUpgradeFilter";
        String pathSpec = "/*";
        FilterHolder holder = new FilterHolder((Filter)new WebSocketUpgradeFilter());
        holder.setName("WebSocketUpgradeFilter");
        holder.setInitParameter(MAPPING_ATTRIBUTE_INIT_PARAM, "org.eclipse.jetty.websocket.util.server.internal.WebSocketMapping");
        holder.setAsyncSupported(true);
        ServletHandler servletHandler = (ServletHandler)ContextHandler.getContextHandler((ServletContext)servletContext).getChildHandlerByClass(ServletHandler.class);
        servletHandler.addFilterWithMapping(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding {} mapped to {} in {}", new Object[]{holder, "/*", servletContext});
        }
        return holder;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpreq = (HttpServletRequest)request;
        HttpServletResponse httpresp = (HttpServletResponse)response;
        if (this.mapping.upgrade(httpreq, httpresp, (Configuration.Customizer)this.defaultCustomizer)) {
            return;
        }
        if (response.isCommitted()) {
            return;
        }
        chain.doFilter(request, response);
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)this, (Object[])new Object[]{this.mapping});
    }

    public void init(FilterConfig config) throws ServletException {
        String autoFragment;
        ServletContext context = config.getServletContext();
        String mappingKey = config.getInitParameter(MAPPING_ATTRIBUTE_INIT_PARAM);
        this.mapping = mappingKey != null ? WebSocketMapping.ensureMapping(context, mappingKey) : new WebSocketMapping(WebSocketServerComponents.ensureWebSocketComponents((ServletContext)context));
        String max = config.getInitParameter("idleTimeout");
        if (max == null && (max = config.getInitParameter("maxIdleTime")) != null) {
            LOG.warn("'maxIdleTime' init param is deprecated, use 'idleTimeout' instead");
        }
        if (max != null) {
            this.defaultCustomizer.setIdleTimeout(Duration.ofMillis(Long.parseLong(max)));
        }
        if ((max = config.getInitParameter("maxTextMessageSize")) != null) {
            this.defaultCustomizer.setMaxTextMessageSize((long)Integer.parseInt(max));
        }
        if ((max = config.getInitParameter("maxBinaryMessageSize")) != null) {
            this.defaultCustomizer.setMaxBinaryMessageSize((long)Integer.parseInt(max));
        }
        if ((max = config.getInitParameter("inputBufferSize")) != null) {
            this.defaultCustomizer.setInputBufferSize(Integer.parseInt(max));
        }
        if ((max = config.getInitParameter("outputBufferSize")) != null) {
            this.defaultCustomizer.setOutputBufferSize(Integer.parseInt(max));
        }
        if ((max = config.getInitParameter("maxFrameSize")) == null) {
            max = config.getInitParameter("maxAllowedFrameSize");
        }
        if (max != null) {
            this.defaultCustomizer.setMaxFrameSize(Long.parseLong(max));
        }
        if ((autoFragment = config.getInitParameter("autoFragment")) != null) {
            this.defaultCustomizer.setAutoFragment(Boolean.parseBoolean(autoFragment));
        }
    }

    public void destroy() {
    }
}

