/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.mux.op;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.mux.MuxControlBlock;

public class MuxAddChannelResponse
implements MuxControlBlock {
    public static final byte IDENTITY_ENCODING = 0;
    public static final byte DELTA_ENCODING = 1;
    private long channelId;
    private byte encoding;
    private byte rsv;
    private boolean failed = false;
    private ByteBuffer handshake;

    public long getChannelId() {
        return this.channelId;
    }

    public byte getEncoding() {
        return this.encoding;
    }

    public ByteBuffer getHandshake() {
        return this.handshake;
    }

    public long getHandshakeSize() {
        if (this.handshake == null) {
            return 0L;
        }
        return this.handshake.remaining();
    }

    @Override
    public int getOpCode() {
        return 1;
    }

    public byte getRsv() {
        return this.rsv;
    }

    public boolean isDeltaEncoded() {
        return this.encoding == 1;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean isIdentityEncoded() {
        return this.encoding == 0;
    }

    public void setChannelId(long channelId) {
        this.channelId = channelId;
    }

    public void setEncoding(byte enc) {
        this.encoding = enc;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public void setHandshake(ByteBuffer handshake) {
        this.handshake = handshake == null ? null : handshake.slice();
    }

    public void setHandshake(String responseHandshake) {
        this.setHandshake(BufferUtil.toBuffer((String)responseHandshake, (Charset)StandardCharsets.UTF_8));
    }

    public void setRsv(byte rsv) {
        this.rsv = rsv;
    }
}

