/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.mux;

import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.frames.DataFrame;

public class MuxedFrame
extends DataFrame {
    private long channelId = -1L;

    public MuxedFrame() {
        super((byte)2);
    }

    public MuxedFrame(MuxedFrame frame) {
        super((Frame)frame);
        this.channelId = frame.channelId;
    }

    public long getChannelId() {
        return this.channelId;
    }

    public void reset() {
        super.reset();
        this.channelId = -1L;
    }

    public void setChannelId(long channelId) {
        this.channelId = channelId;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(OpCode.name((byte)this.getOpCode()));
        b.append('[');
        b.append("channel=").append(this.channelId);
        b.append(",len=").append(this.getPayloadLength());
        b.append(",fin=").append(this.isFin());
        b.append(",rsv=");
        b.append(this.isRsv1() ? (char)'1' : '.');
        b.append(this.isRsv2() ? (char)'1' : '.');
        b.append(this.isRsv3() ? (char)'1' : '.');
        b.append(']');
        return b.toString();
    }

    public void setOp(byte opcode) {
    }
}

