/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketContainer;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WebSocketSessionListener;
import org.eclipse.jetty.websocket.common.SessionTracker;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.exception.WebSocketException;
import org.eclipse.jetty.websocket.core.internal.util.ReflectUtils;
import org.eclipse.jetty.websocket.core.server.FrameHandlerFactory;
import org.eclipse.jetty.websocket.core.server.Handshaker;
import org.eclipse.jetty.websocket.core.server.WebSocketCreator;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.websocket.server.internal.DelegatedServerUpgradeRequest;
import org.eclipse.jetty.websocket.server.internal.DelegatedServerUpgradeResponse;
import org.eclipse.jetty.websocket.server.internal.JettyServerFrameHandlerFactory;
import org.eclipse.jetty.websocket.servlet.WebSocketUpgradeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketServerContainer
extends ContainerLifeCycle
implements WebSocketContainer,
WebSocketPolicy,
LifeCycle.Listener {
    public static final String JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE = WebSocketContainer.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(JettyWebSocketServerContainer.class);
    private final ServletContextHandler contextHandler;
    private final WebSocketMappings webSocketMappings;
    private final WebSocketComponents components;
    private final JettyServerFrameHandlerFactory frameHandlerFactory;
    private final Executor executor;
    private final Configuration.ConfigurationCustomizer customizer = new Configuration.ConfigurationCustomizer();
    private final List<WebSocketSessionListener> sessionListeners = new ArrayList<WebSocketSessionListener>();
    private final SessionTracker sessionTracker = new SessionTracker();

    public static JettyWebSocketServerContainer getContainer(ServletContext servletContext) {
        return (JettyWebSocketServerContainer)((Object)servletContext.getAttribute(JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE));
    }

    public static JettyWebSocketServerContainer ensureContainer(ServletContext servletContext) {
        final ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler((ServletContext)servletContext, (String)"Javax Websocket");
        if (contextHandler.getServer() == null) {
            throw new IllegalStateException("Server has not been set on the ServletContextHandler");
        }
        JettyWebSocketServerContainer containerFromServletContext = JettyWebSocketServerContainer.getContainer(servletContext);
        if (containerFromServletContext != null) {
            return containerFromServletContext;
        }
        Executor executor = (Executor)servletContext.getAttribute("org.eclipse.jetty.server.Executor");
        if (executor == null) {
            executor = contextHandler.getServer().getThreadPool();
        }
        WebSocketMappings mappings = WebSocketMappings.ensureMappings((ServletContext)servletContext);
        WebSocketComponents components = WebSocketServerComponents.getWebSocketComponents((ServletContext)servletContext);
        final JettyWebSocketServerContainer container = new JettyWebSocketServerContainer(contextHandler, mappings, components, executor);
        contextHandler.addManaged((LifeCycle)container);
        contextHandler.addEventListener((EventListener)((Object)container));
        contextHandler.addEventListener((EventListener)new LifeCycle.Listener(){

            public void lifeCycleStopping(LifeCycle event) {
                contextHandler.getServletContext().removeAttribute(JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE);
                contextHandler.removeBean((Object)container);
                contextHandler.removeEventListener((EventListener)((Object)container));
                contextHandler.removeEventListener((EventListener)((Object)this));
            }
        });
        servletContext.setAttribute(JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE, (Object)container);
        return container;
    }

    JettyWebSocketServerContainer(ServletContextHandler contextHandler, WebSocketMappings webSocketMappings, WebSocketComponents components, Executor executor) {
        this.contextHandler = contextHandler;
        this.webSocketMappings = webSocketMappings;
        this.components = components;
        this.executor = executor;
        this.frameHandlerFactory = new JettyServerFrameHandlerFactory(this, components);
        this.addBean((Object)this.frameHandlerFactory);
        this.addSessionListener((WebSocketSessionListener)this.sessionTracker);
        this.addBean(this.sessionTracker);
    }

    public void addMapping(String pathSpec, JettyWebSocketCreator creator) {
        PathSpec ps = WebSocketMappings.parsePathSpec((String)pathSpec);
        if (this.webSocketMappings.getWebSocketNegotiator(ps) != null) {
            throw new WebSocketException("Duplicate WebSocket Mapping for PathSpec");
        }
        WebSocketUpgradeFilter.ensureFilter((ServletContext)this.contextHandler.getServletContext());
        WebSocketCreator coreCreator = (req, resp) -> creator.createWebSocket(new DelegatedServerUpgradeRequest(req), new DelegatedServerUpgradeResponse(resp));
        this.webSocketMappings.addMapping(ps, coreCreator, (FrameHandlerFactory)this.frameHandlerFactory, (Configuration.Customizer)this.customizer);
    }

    public void addMapping(String pathSpec, Class<?> endpointClass) {
        if (!ReflectUtils.isDefaultConstructable(endpointClass)) {
            throw new IllegalArgumentException("Cannot access default constructor for the class: " + endpointClass.getName());
        }
        this.addMapping(pathSpec, (JettyServerUpgradeRequest req, JettyServerUpgradeResponse resp) -> {
            try {
                return endpointClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new org.eclipse.jetty.websocket.api.exceptions.WebSocketException("Unable to create instance of " + endpointClass.getName(), (Throwable)e);
            }
        });
    }

    public boolean upgrade(JettyWebSocketCreator creator, HttpServletRequest request, HttpServletResponse response) throws IOException {
        WebSocketCreator coreCreator = (req, resp) -> creator.createWebSocket(new DelegatedServerUpgradeRequest(req), new DelegatedServerUpgradeResponse(resp));
        WebSocketNegotiator negotiator = WebSocketNegotiator.from((WebSocketCreator)coreCreator, (FrameHandlerFactory)this.frameHandlerFactory, (Configuration.Customizer)this.customizer);
        Handshaker handshaker = this.webSocketMappings.getHandshaker();
        return handshaker.upgradeRequest(negotiator, request, response, this.components, null);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void addSessionListener(WebSocketSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public boolean removeSessionListener(WebSocketSessionListener listener) {
        return this.sessionListeners.remove(listener);
    }

    public void notifySessionListeners(Consumer<WebSocketSessionListener> consumer) {
        for (WebSocketSessionListener listener : this.sessionListeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable x) {
                LOG.info("Exception while invoking listener {}", (Object)listener, (Object)x);
            }
        }
    }

    public Collection<Session> getOpenSessions() {
        return this.sessionTracker.getSessions();
    }

    public WebSocketBehavior getBehavior() {
        return WebSocketBehavior.SERVER;
    }

    public Duration getIdleTimeout() {
        return this.customizer.getIdleTimeout();
    }

    public int getInputBufferSize() {
        return this.customizer.getInputBufferSize();
    }

    public int getOutputBufferSize() {
        return this.customizer.getOutputBufferSize();
    }

    public long getMaxBinaryMessageSize() {
        return this.customizer.getMaxBinaryMessageSize();
    }

    public long getMaxTextMessageSize() {
        return this.customizer.getMaxTextMessageSize();
    }

    public long getMaxFrameSize() {
        return this.customizer.getMaxFrameSize();
    }

    public boolean isAutoFragment() {
        return this.customizer.isAutoFragment();
    }

    public void setIdleTimeout(Duration duration) {
        this.customizer.setIdleTimeout(duration);
    }

    public void setInputBufferSize(int size) {
        this.customizer.setInputBufferSize(size);
    }

    public void setOutputBufferSize(int size) {
        this.customizer.setOutputBufferSize(size);
    }

    public void setMaxBinaryMessageSize(long size) {
        this.customizer.setMaxBinaryMessageSize(size);
    }

    public void setMaxTextMessageSize(long size) {
        this.customizer.setMaxTextMessageSize(size);
    }

    public void setMaxFrameSize(long maxFrameSize) {
        this.customizer.setMaxFrameSize(maxFrameSize);
    }

    public void setAutoFragment(boolean autoFragment) {
        this.customizer.setAutoFragment(autoFragment);
    }
}

