/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketContainer;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WebSocketSessionListener;
import org.eclipse.jetty.websocket.common.SessionTracker;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.exception.WebSocketException;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.websocket.server.internal.JettyServerFrameHandlerFactory;
import org.eclipse.jetty.websocket.util.server.internal.FrameHandlerFactory;
import org.eclipse.jetty.websocket.util.server.internal.WebSocketMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketServerContainer
extends ContainerLifeCycle
implements WebSocketContainer,
WebSocketPolicy,
LifeCycle.Listener {
    public static final String JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE = WebSocketContainer.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(JettyWebSocketServerContainer.class);
    private final WebSocketMapping webSocketMapping;
    private final WebSocketComponents webSocketComponents;
    private final FrameHandlerFactory frameHandlerFactory;
    private final Executor executor;
    private final Configuration.ConfigurationCustomizer customizer = new Configuration.ConfigurationCustomizer();
    private final List<WebSocketSessionListener> sessionListeners = new ArrayList<WebSocketSessionListener>();
    private final SessionTracker sessionTracker = new SessionTracker();

    public static JettyWebSocketServerContainer getContainer(ServletContext servletContext) {
        return (JettyWebSocketServerContainer)((Object)servletContext.getAttribute(JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE));
    }

    public static JettyWebSocketServerContainer ensureContainer(ServletContext servletContext) {
        ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler((ServletContext)servletContext, (String)"Javax Websocket");
        if (contextHandler.getServer() == null) {
            throw new IllegalStateException("Server has not been set on the ServletContextHandler");
        }
        JettyWebSocketServerContainer container = JettyWebSocketServerContainer.getContainer(servletContext);
        if (container == null) {
            Executor executor = (Executor)servletContext.getAttribute("org.eclipse.jetty.server.Executor");
            if (executor == null) {
                executor = contextHandler.getServer().getThreadPool();
            }
            container = new JettyWebSocketServerContainer(contextHandler, WebSocketMapping.ensureMapping((ServletContext)servletContext, (String)"org.eclipse.jetty.websocket.util.server.internal.WebSocketMapping"), WebSocketServerComponents.ensureWebSocketComponents((ServletContext)servletContext), executor);
            servletContext.setAttribute(JETTY_WEBSOCKET_CONTAINER_ATTRIBUTE, (Object)container);
            contextHandler.addManaged((LifeCycle)container);
            contextHandler.addEventListener((EventListener)((Object)container));
        }
        return container;
    }

    JettyWebSocketServerContainer(ServletContextHandler contextHandler, WebSocketMapping webSocketMapping, WebSocketComponents webSocketComponents, Executor executor) {
        this.webSocketMapping = webSocketMapping;
        this.webSocketComponents = webSocketComponents;
        this.executor = executor;
        JettyServerFrameHandlerFactory factory = (JettyServerFrameHandlerFactory)((Object)contextHandler.getBean(JettyServerFrameHandlerFactory.class));
        if (factory == null) {
            factory = new JettyServerFrameHandlerFactory(this);
            contextHandler.addManaged((LifeCycle)factory);
            contextHandler.addEventListener((EventListener)((Object)factory));
        }
        this.frameHandlerFactory = factory;
        this.addSessionListener((WebSocketSessionListener)this.sessionTracker);
    }

    public void addMapping(String pathSpec, JettyWebSocketCreator creator) {
        PathSpec ps = WebSocketMapping.parsePathSpec((String)pathSpec);
        if (this.webSocketMapping.getMapping(ps) != null) {
            throw new WebSocketException("Duplicate WebSocket Mapping for PathSpec");
        }
        this.webSocketMapping.addMapping(ps, (req, resp) -> creator.createWebSocket(new JettyServerUpgradeRequest(req), new JettyServerUpgradeResponse(resp)), this.frameHandlerFactory, (Configuration.Customizer)this.customizer);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void addSessionListener(WebSocketSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public boolean removeSessionListener(WebSocketSessionListener listener) {
        return this.sessionListeners.remove(listener);
    }

    public void notifySessionListeners(Consumer<WebSocketSessionListener> consumer) {
        for (WebSocketSessionListener listener : this.sessionListeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable x) {
                LOG.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    public Collection<Session> getOpenSessions() {
        return this.sessionTracker.getSessions();
    }

    public WebSocketBehavior getBehavior() {
        return WebSocketBehavior.SERVER;
    }

    public Duration getIdleTimeout() {
        return this.customizer.getIdleTimeout();
    }

    public int getInputBufferSize() {
        return this.customizer.getInputBufferSize();
    }

    public int getOutputBufferSize() {
        return this.customizer.getOutputBufferSize();
    }

    public long getMaxBinaryMessageSize() {
        return this.customizer.getMaxBinaryMessageSize();
    }

    public long getMaxTextMessageSize() {
        return this.customizer.getMaxTextMessageSize();
    }

    public long getMaxFrameSize() {
        return this.customizer.getMaxFrameSize();
    }

    public boolean isAutoFragment() {
        return this.customizer.isAutoFragment();
    }

    public void setIdleTimeout(Duration duration) {
        this.customizer.setIdleTimeout(duration);
    }

    public void setInputBufferSize(int size) {
        this.customizer.setInputBufferSize(size);
    }

    public void setOutputBufferSize(int size) {
        this.customizer.setOutputBufferSize(size);
    }

    public void setMaxBinaryMessageSize(long size) {
        this.customizer.setMaxBinaryMessageSize(size);
    }

    public void setMaxTextMessageSize(long size) {
        this.customizer.setMaxTextMessageSize(size);
    }

    public void setMaxFrameSize(long maxFrameSize) {
        this.customizer.setMaxFrameSize(maxFrameSize);
    }

    public void setAutoFragment(boolean autoFragment) {
        this.customizer.setAutoFragment(autoFragment);
    }
}

