/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common.messages;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedMessageSink;
import org.eclipse.jetty.websocket.util.messages.MessageSink;
import org.eclipse.jetty.websocket.util.messages.StringMessageSink;

public class DecodedTextMessageSink<T>
extends DecodedMessageSink<Decoder.Text<T>> {
    public DecodedTextMessageSink(CoreSession session, Decoder.Text<T> decoder, MethodHandle methodHandle) throws NoSuchMethodException, IllegalAccessException {
        super(session, decoder, methodHandle);
    }

    @Override
    protected MethodHandle newRawMethodHandle() throws NoSuchMethodException, IllegalAccessException {
        return MethodHandles.lookup().findVirtual(DecodedTextMessageSink.class, "onWholeMessage", MethodType.methodType(Void.TYPE, String.class)).bindTo((Object)this);
    }

    @Override
    protected MessageSink newRawMessageSink(CoreSession session, MethodHandle rawMethodHandle) {
        return new StringMessageSink(session, rawMethodHandle);
    }

    public void onWholeMessage(String wholeMessage) {
        if (!((Decoder.Text)this.getDecoder()).willDecode(wholeMessage)) {
            this.logger.warn("Message lost, decoder " + ((Decoder.Text)this.getDecoder()).getClass().getName() + "#willDecode() has rejected it.");
            return;
        }
        try {
            Object obj = ((Decoder.Text)this.getDecoder()).decode(wholeMessage);
            this.methodHandle.invoke(obj);
        }
        catch (DecodeException e) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Unable to decode", (Throwable)e);
        }
        catch (Throwable t) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Endpoint notification error", t);
        }
    }
}

