/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common.messages;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.javax.common.messages.DecodedMessageSink;
import org.eclipse.jetty.websocket.util.messages.ByteBufferMessageSink;
import org.eclipse.jetty.websocket.util.messages.MessageSink;

public class DecodedBinaryMessageSink<T>
extends DecodedMessageSink<Decoder.Binary<T>> {
    public DecodedBinaryMessageSink(CoreSession session, Decoder.Binary<T> decoder, MethodHandle methodHandle) throws NoSuchMethodException, IllegalAccessException {
        super(session, decoder, methodHandle);
    }

    @Override
    protected MethodHandle newRawMethodHandle() throws NoSuchMethodException, IllegalAccessException {
        return MethodHandles.lookup().findVirtual(DecodedBinaryMessageSink.class, "onWholeMessage", MethodType.methodType(Void.TYPE, ByteBuffer.class)).bindTo((Object)this);
    }

    @Override
    protected MessageSink newRawMessageSink(CoreSession session, MethodHandle rawMethodHandle) {
        return new ByteBufferMessageSink(session, rawMethodHandle);
    }

    public void onWholeMessage(ByteBuffer wholeMessage) {
        if (!((Decoder.Binary)this.getDecoder()).willDecode(wholeMessage)) {
            this.logger.warn("Message lost, decoder " + ((Decoder.Binary)this.getDecoder()).getClass().getName() + "#willDecode() has rejected it.");
            return;
        }
        try {
            Object obj = ((Decoder.Binary)this.getDecoder()).decode(wholeMessage);
            this.methodHandle.invoke(obj);
        }
        catch (DecodeException e) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Unable to decode", (Throwable)e);
        }
        catch (Throwable t) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Endpoint notification error", t);
        }
    }
}

