/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.server.internal;

import jakarta.servlet.ServletContext;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.client.WebSocketCoreClient;
import org.eclipse.jetty.websocket.core.exception.InvalidSignatureException;
import org.eclipse.jetty.websocket.core.internal.util.ReflectUtils;
import org.eclipse.jetty.websocket.core.server.FrameHandlerFactory;
import org.eclipse.jetty.websocket.core.server.WebSocketCreator;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.eclipse.jetty.websocket.jakarta.client.internal.JakartaWebSocketClientContainer;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketContainer;
import org.eclipse.jetty.websocket.jakarta.server.config.ContainerDefaultConfigurator;
import org.eclipse.jetty.websocket.jakarta.server.internal.AnnotatedServerEndpointConfig;
import org.eclipse.jetty.websocket.jakarta.server.internal.JakartaWebSocketCreator;
import org.eclipse.jetty.websocket.jakarta.server.internal.JakartaWebSocketServerFrameHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="JSR356 Server Container")
public class JakartaWebSocketServerContainer
extends JakartaWebSocketClientContainer
implements ServerContainer,
LifeCycle.Listener {
    public static final String JAKARTA_WEBSOCKET_CONTAINER_ATTRIBUTE = ServerContainer.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(JakartaWebSocketServerContainer.class);
    private final WebSocketMappings webSocketMappings;
    private final JakartaWebSocketServerFrameHandlerFactory frameHandlerFactory;
    private List<Class<?>> deferredEndpointClasses;
    private List<ServerEndpointConfig> deferredEndpointConfigs;

    public static JakartaWebSocketServerContainer getContainer(ServletContext servletContext) {
        return (JakartaWebSocketServerContainer)((Object)servletContext.getAttribute(JAKARTA_WEBSOCKET_CONTAINER_ATTRIBUTE));
    }

    public static JakartaWebSocketServerContainer ensureContainer(ServletContext servletContext) {
        ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler((ServletContext)servletContext, (String)"Jakarta Websocket");
        if (contextHandler.getServer() == null) {
            throw new IllegalStateException("Server has not been set on the ServletContextHandler");
        }
        JakartaWebSocketServerContainer container = JakartaWebSocketServerContainer.getContainer(servletContext);
        if (container == null) {
            Function<WebSocketComponents, WebSocketCoreClient> coreClientSupplier = arg_0 -> JakartaWebSocketServerContainer.lambda$ensureContainer$0(servletContext, (ContextHandler)contextHandler, arg_0);
            container = new JakartaWebSocketServerContainer(WebSocketMappings.ensureMappings((ServletContext)servletContext), WebSocketServerComponents.getWebSocketComponents((ServletContext)servletContext), coreClientSupplier);
            contextHandler.addManaged((LifeCycle)container);
            contextHandler.addEventListener((EventListener)((Object)container));
        }
        servletContext.setAttribute(JAKARTA_WEBSOCKET_CONTAINER_ATTRIBUTE, (Object)container);
        return container;
    }

    public JakartaWebSocketServerContainer(WebSocketMappings webSocketMappings) {
        this(webSocketMappings, new WebSocketComponents());
    }

    public JakartaWebSocketServerContainer(WebSocketMappings webSocketMappings, WebSocketComponents components) {
        super(components);
        this.webSocketMappings = webSocketMappings;
        this.frameHandlerFactory = new JakartaWebSocketServerFrameHandlerFactory((JakartaWebSocketContainer)this);
    }

    public JakartaWebSocketServerContainer(WebSocketMappings webSocketMappings, WebSocketComponents components, Function<WebSocketComponents, WebSocketCoreClient> coreClientSupplier) {
        super(components, coreClientSupplier);
        this.webSocketMappings = webSocketMappings;
        this.frameHandlerFactory = new JakartaWebSocketServerFrameHandlerFactory((JakartaWebSocketContainer)this);
    }

    public void lifeCycleStopping(LifeCycle context) {
        ContextHandler contextHandler = (ContextHandler)context;
        JakartaWebSocketServerContainer container = (JakartaWebSocketServerContainer)((Object)contextHandler.getBean(JakartaWebSocketServerContainer.class));
        if (container == this) {
            contextHandler.removeBean((Object)container);
            LifeCycle.stop((Object)((Object)container));
        }
    }

    public JakartaWebSocketServerFrameHandlerFactory getFrameHandlerFactory() {
        return this.frameHandlerFactory;
    }

    private void validateEndpointConfig(ServerEndpointConfig config) throws DeploymentException {
        if (config == null) {
            throw new DeploymentException("Unable to deploy null ServerEndpointConfig");
        }
        ServerEndpointConfig.Configurator configurator = config.getConfigurator();
        if (configurator == null) {
            throw new DeploymentException("Unable to deploy with null ServerEndpointConfig.Configurator");
        }
        Class endpointClass = config.getEndpointClass();
        if (endpointClass == null) {
            throw new DeploymentException("Unable to deploy null endpoint class from ServerEndpointConfig: " + config.getClass().getName());
        }
        if (!Modifier.isPublic(endpointClass.getModifiers())) {
            throw new DeploymentException("Class is not public: " + endpointClass.getName());
        }
        if (configurator.getClass() == ContainerDefaultConfigurator.class && !ReflectUtils.isDefaultConstructable((Class)endpointClass)) {
            throw new DeploymentException("Cannot access default constructor for the class: " + endpointClass.getName());
        }
    }

    public void addEndpoint(Class<?> endpointClass) throws DeploymentException {
        if (endpointClass == null) {
            throw new DeploymentException("Unable to deploy null endpoint class");
        }
        if (this.isStarted() || this.isStarting()) {
            ServerEndpoint anno = endpointClass.getAnnotation(ServerEndpoint.class);
            if (anno == null) {
                throw new DeploymentException(String.format("Class must be @%s annotated: %s", ServerEndpoint.class.getName(), endpointClass.getName()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("addEndpoint({})", endpointClass);
            }
            AnnotatedServerEndpointConfig config = new AnnotatedServerEndpointConfig((JakartaWebSocketContainer)this, endpointClass, anno);
            this.validateEndpointConfig((ServerEndpointConfig)config);
            this.addEndpointMapping((ServerEndpointConfig)config);
        } else {
            if (this.deferredEndpointClasses == null) {
                this.deferredEndpointClasses = new ArrayList();
            }
            this.deferredEndpointClasses.add(endpointClass);
        }
    }

    public void addEndpoint(ServerEndpointConfig providedConfig) throws DeploymentException {
        if (providedConfig == null) {
            throw new DeploymentException("ServerEndpointConfig is null");
        }
        if (this.isStarted() || this.isStarting()) {
            Object config;
            Class endpointClass = providedConfig.getEndpointClass();
            ServerEndpoint anno = endpointClass.getAnnotation(ServerEndpoint.class);
            Object object = config = anno == null ? providedConfig : new AnnotatedServerEndpointConfig((JakartaWebSocketContainer)this, endpointClass, anno, (EndpointConfig)providedConfig);
            if (LOG.isDebugEnabled()) {
                LOG.debug("addEndpoint({}) path={} endpoint={}", new Object[]{config, config.getPath(), endpointClass});
            }
            this.validateEndpointConfig((ServerEndpointConfig)config);
            this.addEndpointMapping((ServerEndpointConfig)config);
        } else {
            if (this.deferredEndpointConfigs == null) {
                this.deferredEndpointConfigs = new ArrayList<ServerEndpointConfig>();
            }
            this.deferredEndpointConfigs.add(providedConfig);
        }
    }

    private void addEndpointMapping(ServerEndpointConfig config) throws DeploymentException {
        try {
            this.frameHandlerFactory.getMetadata(config.getEndpointClass(), (EndpointConfig)config);
            JakartaWebSocketCreator creator = new JakartaWebSocketCreator((JakartaWebSocketContainer)this, config, this.getExtensionRegistry());
            UriTemplatePathSpec pathSpec = new UriTemplatePathSpec(config.getPath());
            this.webSocketMappings.addMapping((PathSpec)pathSpec, (WebSocketCreator)creator, (FrameHandlerFactory)this.frameHandlerFactory, (Configuration.Customizer)this.defaultCustomizer);
        }
        catch (InvalidSignatureException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        catch (Throwable t) {
            throw new DeploymentException("Unable to deploy: " + config.getEndpointClass().getName(), t);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.deferredEndpointClasses != null) {
            for (Class<?> endpointClass : this.deferredEndpointClasses) {
                this.addEndpoint(endpointClass);
            }
            this.deferredEndpointClasses.clear();
        }
        if (this.deferredEndpointConfigs != null) {
            for (ServerEndpointConfig config : this.deferredEndpointConfigs) {
                this.addEndpoint(config);
            }
            this.deferredEndpointConfigs.clear();
        }
    }

    protected void doClientStart() {
    }

    protected void doClientStop() {
    }

    private static /* synthetic */ WebSocketCoreClient lambda$ensureContainer$0(ServletContext servletContext, ContextHandler contextHandler, WebSocketComponents wsComponents) {
        WebSocketCoreClient coreClient = (WebSocketCoreClient)servletContext.getAttribute(WebSocketCoreClient.WEBSOCKET_CORECLIENT_ATTRIBUTE);
        if (coreClient == null) {
            Executor executor;
            HttpClient httpClient = (HttpClient)servletContext.getAttribute("org.eclipse.jetty.websocket.jakarta.HttpClient");
            if (httpClient == null) {
                httpClient = (HttpClient)contextHandler.getServer().getAttribute("org.eclipse.jetty.websocket.jakarta.HttpClient");
            }
            Executor executor2 = executor = httpClient == null ? null : httpClient.getExecutor();
            if (executor == null) {
                executor = (Executor)servletContext.getAttribute("org.eclipse.jetty.server.Executor");
            }
            if (executor == null) {
                executor = contextHandler.getServer().getThreadPool();
            }
            if (httpClient != null && httpClient.getExecutor() == null) {
                httpClient.setExecutor(executor);
            }
            coreClient = new WebSocketCoreClient(httpClient, wsComponents);
            coreClient.getHttpClient().setName("Jakarta-WebSocketClient@" + Integer.toHexString(coreClient.getHttpClient().hashCode()));
            if (executor != null && httpClient == null) {
                coreClient.getHttpClient().setExecutor(executor);
            }
            servletContext.setAttribute(WebSocketCoreClient.WEBSOCKET_CORECLIENT_ATTRIBUTE, (Object)coreClient);
        }
        return coreClient;
    }
}

