/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.common;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Decoder;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.PongMessage;
import jakarta.websocket.Session;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.jakarta.common.ConfiguredEndpoint;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketContainer;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketFrameHandler;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketFrameHandlerMetadata;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketMessageMetadata;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketSession;
import org.eclipse.jetty.websocket.jakarta.common.UpgradeRequest;
import org.eclipse.jetty.websocket.jakarta.common.decoders.RegisteredDecoder;
import org.eclipse.jetty.websocket.jakarta.common.messages.AbstractDecodedMessageSink;
import org.eclipse.jetty.websocket.jakarta.common.messages.DecodedBinaryMessageSink;
import org.eclipse.jetty.websocket.jakarta.common.messages.DecodedBinaryStreamMessageSink;
import org.eclipse.jetty.websocket.jakarta.common.messages.DecodedTextMessageSink;
import org.eclipse.jetty.websocket.jakarta.common.messages.DecodedTextStreamMessageSink;
import org.eclipse.jetty.websocket.util.InvalidSignatureException;
import org.eclipse.jetty.websocket.util.InvalidWebSocketException;
import org.eclipse.jetty.websocket.util.InvokerUtils;
import org.eclipse.jetty.websocket.util.ReflectUtils;
import org.eclipse.jetty.websocket.util.messages.MessageSink;
import org.eclipse.jetty.websocket.util.messages.PartialByteArrayMessageSink;
import org.eclipse.jetty.websocket.util.messages.PartialByteBufferMessageSink;
import org.eclipse.jetty.websocket.util.messages.PartialStringMessageSink;

public abstract class JakartaWebSocketFrameHandlerFactory {
    private static final MethodHandle FILTER_RETURN_TYPE_METHOD;
    static final InvokerUtils.Arg[] textPartialCallingArgs;
    static final InvokerUtils.Arg[] binaryPartialBufferCallingArgs;
    static final InvokerUtils.Arg[] binaryPartialArrayCallingArgs;
    static final InvokerUtils.Arg[] pongCallingArgs;
    protected final JakartaWebSocketContainer container;
    protected final InvokerUtils.ParamIdentifier paramIdentifier;

    static InvokerUtils.Arg[] getArgsFor(Class<?> objectType) {
        return new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(objectType).required()};
    }

    public JakartaWebSocketFrameHandlerFactory(JakartaWebSocketContainer container, InvokerUtils.ParamIdentifier paramIdentifier) {
        this.container = container;
        this.paramIdentifier = paramIdentifier == null ? InvokerUtils.PARAM_IDENTITY : paramIdentifier;
    }

    public abstract JakartaWebSocketFrameHandlerMetadata getMetadata(Class<?> var1, EndpointConfig var2);

    public abstract EndpointConfig newDefaultEndpointConfig(Class<?> var1);

    public JakartaWebSocketFrameHandler newJakartaWebSocketFrameHandler(Object endpointInstance, UpgradeRequest upgradeRequest) {
        EndpointConfig config;
        Object endpoint;
        if (endpointInstance instanceof ConfiguredEndpoint) {
            ConfiguredEndpoint configuredEndpoint = (ConfiguredEndpoint)endpointInstance;
            endpoint = configuredEndpoint.getRawEndpoint();
            config = configuredEndpoint.getConfig();
        } else {
            endpoint = endpointInstance;
            config = this.newDefaultEndpointConfig(endpoint.getClass());
        }
        JakartaWebSocketFrameHandlerMetadata metadata = this.getMetadata(endpoint.getClass(), config);
        if (metadata == null) {
            return null;
        }
        MethodHandle openHandle = metadata.getOpenHandle();
        MethodHandle closeHandle = metadata.getCloseHandle();
        MethodHandle errorHandle = metadata.getErrorHandle();
        MethodHandle pongHandle = metadata.getPongHandle();
        JakartaWebSocketMessageMetadata textMetadata = JakartaWebSocketMessageMetadata.copyOf(metadata.getTextMetadata());
        JakartaWebSocketMessageMetadata binaryMetadata = JakartaWebSocketMessageMetadata.copyOf(metadata.getBinaryMetadata());
        UriTemplatePathSpec templatePathSpec = metadata.getUriTemplatePathSpec();
        if (templatePathSpec != null) {
            String[] namedVariables = templatePathSpec.getVariables();
            Map pathParams = templatePathSpec.getPathParams(upgradeRequest.getPathInContext());
            openHandle = JakartaWebSocketFrameHandlerFactory.bindTemplateVariables(openHandle, namedVariables, pathParams);
            closeHandle = JakartaWebSocketFrameHandlerFactory.bindTemplateVariables(closeHandle, namedVariables, pathParams);
            errorHandle = JakartaWebSocketFrameHandlerFactory.bindTemplateVariables(errorHandle, namedVariables, pathParams);
            pongHandle = JakartaWebSocketFrameHandlerFactory.bindTemplateVariables(pongHandle, namedVariables, pathParams);
            if (textMetadata != null) {
                textMetadata.setMethodHandle(JakartaWebSocketFrameHandlerFactory.bindTemplateVariables(textMetadata.getMethodHandle(), namedVariables, pathParams));
            }
            if (binaryMetadata != null) {
                binaryMetadata.setMethodHandle(JakartaWebSocketFrameHandlerFactory.bindTemplateVariables(binaryMetadata.getMethodHandle(), namedVariables, pathParams));
            }
        }
        openHandle = InvokerUtils.bindTo((MethodHandle)openHandle, (Object[])new Object[]{endpoint});
        closeHandle = InvokerUtils.bindTo((MethodHandle)closeHandle, (Object[])new Object[]{endpoint});
        errorHandle = InvokerUtils.bindTo((MethodHandle)errorHandle, (Object[])new Object[]{endpoint});
        pongHandle = InvokerUtils.bindTo((MethodHandle)pongHandle, (Object[])new Object[]{endpoint});
        return new JakartaWebSocketFrameHandler(this.container, endpoint, openHandle, closeHandle, errorHandle, textMetadata, binaryMetadata, pongHandle, config);
    }

    public static MessageSink createMessageSink(JakartaWebSocketSession session, JakartaWebSocketMessageMetadata msgMetadata) {
        if (msgMetadata == null) {
            return null;
        }
        try {
            MethodHandles.Lookup lookup = JakartaWebSocketFrameHandlerFactory.getServerMethodHandleLookup();
            if (AbstractDecodedMessageSink.class.isAssignableFrom(msgMetadata.getSinkClass())) {
                MethodHandle ctorHandle = lookup.findConstructor(msgMetadata.getSinkClass(), MethodType.methodType(Void.TYPE, CoreSession.class, MethodHandle.class, List.class));
                List<RegisteredDecoder> registeredDecoders = msgMetadata.getRegisteredDecoders();
                return ctorHandle.invoke(session.getCoreSession(), msgMetadata.getMethodHandle(), registeredDecoders);
            }
            MethodHandle ctorHandle = lookup.findConstructor(msgMetadata.getSinkClass(), MethodType.methodType(Void.TYPE, CoreSession.class, MethodHandle.class));
            return ctorHandle.invoke(session.getCoreSession(), msgMetadata.getMethodHandle());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Missing expected MessageSink constructor found at: " + msgMetadata.getSinkClass().getName(), e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Unable to create MessageSink: " + msgMetadata.getSinkClass().getName(), e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static MethodHandle wrapNonVoidReturnType(MethodHandle handle, JakartaWebSocketSession session) {
        if (handle == null) {
            return null;
        }
        if (handle.type().returnType() == Void.TYPE) {
            return handle;
        }
        handle = handle.asType(handle.type().changeReturnType(Object.class));
        handle = MethodHandles.filterReturnValue(handle, FILTER_RETURN_TYPE_METHOD.bindTo(session));
        return handle;
    }

    private MethodHandle toMethodHandle(MethodHandles.Lookup lookup, Method method) {
        try {
            return lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to access method " + method, e);
        }
    }

    protected JakartaWebSocketFrameHandlerMetadata createEndpointMetadata(EndpointConfig endpointConfig) {
        JakartaWebSocketFrameHandlerMetadata metadata = new JakartaWebSocketFrameHandlerMetadata(endpointConfig);
        MethodHandles.Lookup lookup = JakartaWebSocketFrameHandlerFactory.getServerMethodHandleLookup();
        Method openMethod = ReflectUtils.findMethod(Endpoint.class, (String)"onOpen", (Class[])new Class[]{Session.class, EndpointConfig.class});
        MethodHandle open = this.toMethodHandle(lookup, openMethod);
        metadata.setOpenHandler(open, openMethod);
        Method closeMethod = ReflectUtils.findMethod(Endpoint.class, (String)"onClose", (Class[])new Class[]{Session.class, CloseReason.class});
        MethodHandle close = this.toMethodHandle(lookup, closeMethod);
        metadata.setCloseHandler(close, closeMethod);
        Method errorMethod = ReflectUtils.findMethod(Endpoint.class, (String)"onError", (Class[])new Class[]{Session.class, Throwable.class});
        MethodHandle error = this.toMethodHandle(lookup, errorMethod);
        metadata.setErrorHandler(error, errorMethod);
        return metadata;
    }

    protected JakartaWebSocketFrameHandlerMetadata discoverJakartaFrameHandlerMetadata(Class<?> endpointClass, JakartaWebSocketFrameHandlerMetadata metadata) {
        Method[] onMessages;
        MethodHandle methodHandle;
        InvokerUtils.Arg SESSION;
        MethodHandles.Lookup lookup = JakartaWebSocketFrameHandlerFactory.getApplicationMethodHandleLookup(endpointClass);
        Method onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnOpen.class);
        if (onmethod != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnOpen.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg ENDPOINT_CONFIG = new InvokerUtils.Arg(EndpointConfig.class);
            methodHandle = InvokerUtils.mutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onmethod, (InvokerUtils.ParamIdentifier)this.paramIdentifier, (String[])metadata.getNamedTemplateVariables(), (InvokerUtils.Arg[])new InvokerUtils.Arg[]{SESSION, ENDPOINT_CONFIG});
            metadata.setOpenHandler(methodHandle, onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnClose.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnClose.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg CLOSE_REASON = new InvokerUtils.Arg(CloseReason.class);
            methodHandle = InvokerUtils.mutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onmethod, (InvokerUtils.ParamIdentifier)this.paramIdentifier, (String[])metadata.getNamedTemplateVariables(), (InvokerUtils.Arg[])new InvokerUtils.Arg[]{SESSION, CLOSE_REASON});
            metadata.setCloseHandler(methodHandle, onmethod);
        }
        if ((onmethod = ReflectUtils.findAnnotatedMethod(endpointClass, OnError.class)) != null) {
            this.assertSignatureValid(endpointClass, onmethod, OnError.class);
            SESSION = new InvokerUtils.Arg(Session.class);
            InvokerUtils.Arg CAUSE = new InvokerUtils.Arg(Throwable.class).required();
            methodHandle = InvokerUtils.mutatedInvoker((MethodHandles.Lookup)lookup, endpointClass, (Method)onmethod, (InvokerUtils.ParamIdentifier)this.paramIdentifier, (String[])metadata.getNamedTemplateVariables(), (InvokerUtils.Arg[])new InvokerUtils.Arg[]{SESSION, CAUSE});
            metadata.setErrorHandler(methodHandle, onmethod);
        }
        if ((onMessages = ReflectUtils.findAnnotatedMethods(endpointClass, OnMessage.class)) != null && onMessages.length > 0) {
            for (Method onMsg : onMessages) {
                Function<InvokerUtils.Arg[], MethodHandle> getMethodHandle;
                this.assertSignatureValid(endpointClass, onMsg, OnMessage.class);
                OnMessage onMessageAnno = onMsg.getAnnotation(OnMessage.class);
                long annotationMaxMessageSize = onMessageAnno.maxMessageSize();
                if (annotationMaxMessageSize > Integer.MAX_VALUE) {
                    throw new InvalidWebSocketException(String.format("Value too large: %s#%s - @OnMessage.maxMessageSize=%,d > Integer.MAX_VALUE", endpointClass.getName(), onMsg.getName(), annotationMaxMessageSize));
                }
                JakartaWebSocketMessageMetadata msgMetadata = new JakartaWebSocketMessageMetadata();
                if (annotationMaxMessageSize != -1L) {
                    msgMetadata.setMaxMessageSize((int)annotationMaxMessageSize);
                }
                if (this.matchDecoders(onMsg, metadata, msgMetadata, getMethodHandle = signature -> InvokerUtils.optionalMutatedInvoker((MethodHandles.Lookup)lookup, (Class)endpointClass, (Method)onMsg, (InvokerUtils.ParamIdentifier)this.paramIdentifier, (String[])metadata.getNamedTemplateVariables(), (InvokerUtils.Arg[])signature)) || this.matchOnMessage(onMsg, metadata, msgMetadata, getMethodHandle)) continue;
                throw InvalidSignatureException.build(endpointClass, OnMessage.class, (Method)onMsg);
            }
        }
        return metadata;
    }

    private boolean matchOnMessage(Method onMsg, JakartaWebSocketFrameHandlerMetadata metadata, JakartaWebSocketMessageMetadata msgMetadata, Function<InvokerUtils.Arg[], MethodHandle> getMethodHandle) {
        MethodHandle methodHandle = getMethodHandle.apply(textPartialCallingArgs);
        if (methodHandle != null) {
            msgMetadata.setSinkClass(PartialStringMessageSink.class);
            msgMetadata.setMethodHandle(methodHandle);
            metadata.setTextMetadata(msgMetadata, onMsg);
            return true;
        }
        methodHandle = getMethodHandle.apply(binaryPartialBufferCallingArgs);
        if (methodHandle != null) {
            msgMetadata.setSinkClass(PartialByteBufferMessageSink.class);
            msgMetadata.setMethodHandle(methodHandle);
            metadata.setBinaryMetadata(msgMetadata, onMsg);
            return true;
        }
        methodHandle = getMethodHandle.apply(binaryPartialArrayCallingArgs);
        if (methodHandle != null) {
            msgMetadata.setSinkClass(PartialByteArrayMessageSink.class);
            msgMetadata.setMethodHandle(methodHandle);
            metadata.setBinaryMetadata(msgMetadata, onMsg);
            return true;
        }
        MethodHandle pongHandle = getMethodHandle.apply(pongCallingArgs);
        if (pongHandle != null) {
            metadata.setPongHandle(pongHandle, onMsg);
            return true;
        }
        return false;
    }

    private boolean matchDecoders(Method onMsg, JakartaWebSocketFrameHandlerMetadata metadata, JakartaWebSocketMessageMetadata msgMetadata, Function<InvokerUtils.Arg[], MethodHandle> getMethodHandle) {
        RegisteredDecoder firstDecoder = metadata.getAvailableDecoders().stream().filter(registeredDecoder -> getMethodHandle.apply(JakartaWebSocketFrameHandlerFactory.getArgsFor(registeredDecoder.objectType)) != null).findFirst().orElse(null);
        if (firstDecoder == null) {
            return false;
        }
        ArrayList<RegisteredDecoder> decoders = new ArrayList<RegisteredDecoder>();
        Class<? extends Decoder> interfaceType = firstDecoder.interfaceType;
        metadata.getAvailableDecoders().stream().filter(decoder -> decoder.interfaceType.equals(interfaceType) && getMethodHandle.apply(JakartaWebSocketFrameHandlerFactory.getArgsFor(decoder.objectType)) != null).forEach(decoders::add);
        msgMetadata.setRegisteredDecoders(decoders);
        Class<?> objectType = firstDecoder.objectType;
        for (RegisteredDecoder decoder2 : decoders) {
            if (!decoder2.objectType.isAssignableFrom(objectType)) continue;
            objectType = decoder2.objectType;
        }
        MethodHandle methodHandle = getMethodHandle.apply(JakartaWebSocketFrameHandlerFactory.getArgsFor(objectType));
        msgMetadata.setMethodHandle(methodHandle);
        if (interfaceType.equals(Decoder.Text.class)) {
            msgMetadata.setSinkClass(DecodedTextMessageSink.class);
            metadata.setTextMetadata(msgMetadata, onMsg);
        } else if (interfaceType.equals(Decoder.Binary.class)) {
            msgMetadata.setSinkClass(DecodedBinaryMessageSink.class);
            metadata.setBinaryMetadata(msgMetadata, onMsg);
        } else if (interfaceType.equals(Decoder.TextStream.class)) {
            msgMetadata.setSinkClass(DecodedTextStreamMessageSink.class);
            metadata.setTextMetadata(msgMetadata, onMsg);
        } else if (interfaceType.equals(Decoder.BinaryStream.class)) {
            msgMetadata.setSinkClass(DecodedBinaryStreamMessageSink.class);
            metadata.setBinaryMetadata(msgMetadata, onMsg);
        }
        return true;
    }

    private void assertSignatureValid(Class<?> endpointClass, Method method, Class<? extends Annotation> annotationClass) {
        int mods = method.getModifiers();
        if (!Modifier.isPublic(mods)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" method must be public: ");
            ReflectUtils.append((StringBuilder)err, endpointClass, (Method)method);
            throw new InvalidSignatureException(err.toString());
        }
        if (Modifier.isStatic(mods)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" method must not be static: ");
            ReflectUtils.append((StringBuilder)err, endpointClass, (Method)method);
            throw new InvalidSignatureException(err.toString());
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            return;
        }
        if (!OnMessage.class.isAssignableFrom(annotationClass)) {
            StringBuilder err = new StringBuilder();
            err.append("@").append(annotationClass.getSimpleName());
            err.append(" return must be void: ");
            ReflectUtils.append((StringBuilder)err, endpointClass, (Method)method);
            throw new InvalidSignatureException(err.toString());
        }
    }

    public static MethodHandle bindTemplateVariables(MethodHandle target, String[] namedVariables, Map<String, String> templateValues) {
        if (target == null) {
            return null;
        }
        boolean IDX = true;
        MethodHandle retHandle = target;
        if (templateValues == null || templateValues.isEmpty()) {
            return retHandle;
        }
        for (String variableName : namedVariables) {
            String strValue = templateValues.get(variableName);
            TypeDescriptor.OfField type = retHandle.type().parameterType(1);
            try {
                if (String.class.isAssignableFrom((Class<?>)type)) {
                    retHandle = MethodHandles.insertArguments(retHandle, 1, strValue);
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom((Class<?>)type)) {
                    int intValue = Integer.parseInt(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, intValue);
                    continue;
                }
                if (Long.TYPE.isAssignableFrom((Class<?>)type)) {
                    long longValue = Long.parseLong(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, longValue);
                    continue;
                }
                if (Short.TYPE.isAssignableFrom((Class<?>)type)) {
                    short shortValue = Short.parseShort(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, shortValue);
                    continue;
                }
                if (Float.TYPE.isAssignableFrom((Class<?>)type)) {
                    float floatValue = Float.parseFloat(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, Float.valueOf(floatValue));
                    continue;
                }
                if (Double.TYPE.isAssignableFrom((Class<?>)type)) {
                    double doubleValue = Double.parseDouble(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, doubleValue);
                    continue;
                }
                if (Boolean.TYPE.isAssignableFrom((Class<?>)type)) {
                    boolean boolValue = Boolean.parseBoolean(strValue);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, boolValue);
                    continue;
                }
                if (Character.TYPE.isAssignableFrom((Class<?>)type)) {
                    if (strValue.length() != 1) {
                        throw new IllegalArgumentException("Invalid Size");
                    }
                    char charValue = strValue.charAt(0);
                    retHandle = MethodHandles.insertArguments(retHandle, 1, Character.valueOf(charValue));
                    continue;
                }
                if (Byte.TYPE.isAssignableFrom((Class<?>)type)) {
                    byte[] buf = strValue.getBytes(StandardCharsets.UTF_8);
                    if (buf.length != 1) {
                        throw new IllegalArgumentException("Invalid Size");
                    }
                    retHandle = MethodHandles.insertArguments(retHandle, 1, buf[0]);
                    continue;
                }
                throw new IllegalStateException("Unsupported Type: " + (Class)type);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot convert String value <" + strValue + "> to type <" + (Class)type + ">: " + e.getMessage(), e);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot convert String value <" + strValue + "> to type <" + (Class)type + ">: " + e.getMessage());
            }
        }
        return retHandle;
    }

    public static MethodHandles.Lookup getServerMethodHandleLookup() {
        return MethodHandles.lookup();
    }

    public static MethodHandles.Lookup getApplicationMethodHandleLookup(Class<?> lookupClass) {
        return MethodHandles.publicLookup().in(lookupClass);
    }

    static {
        try {
            FILTER_RETURN_TYPE_METHOD = JakartaWebSocketFrameHandlerFactory.getServerMethodHandleLookup().findVirtual(JakartaWebSocketSession.class, "filterReturnType", MethodType.methodType(Void.TYPE, Object.class));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        textPartialCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(String.class).required(), new InvokerUtils.Arg(Boolean.TYPE).required()};
        binaryPartialBufferCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(ByteBuffer.class).required(), new InvokerUtils.Arg(Boolean.TYPE).required()};
        binaryPartialArrayCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(byte[].class).required(), new InvokerUtils.Arg(Boolean.TYPE).required()};
        pongCallingArgs = new InvokerUtils.Arg[]{new InvokerUtils.Arg(Session.class), new InvokerUtils.Arg(PongMessage.class).required()};
    }
}

