/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.common.messages;

import jakarta.websocket.CloseReason;
import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketFrameHandlerFactory;
import org.eclipse.jetty.websocket.jakarta.common.messages.DecodedMessageSink;
import org.eclipse.jetty.websocket.util.messages.MessageSink;
import org.eclipse.jetty.websocket.util.messages.StringMessageSink;

public class DecodedTextMessageSink<T>
extends DecodedMessageSink<Decoder.Text<T>> {
    public DecodedTextMessageSink(CoreSession session, Decoder.Text<T> decoder, MethodHandle methodHandle) throws NoSuchMethodException, IllegalAccessException {
        super(session, decoder, methodHandle);
    }

    @Override
    protected MethodHandle newRawMethodHandle() throws NoSuchMethodException, IllegalAccessException {
        return JakartaWebSocketFrameHandlerFactory.getServerMethodHandleLookup().findVirtual(DecodedTextMessageSink.class, "onWholeMessage", MethodType.methodType(Void.TYPE, String.class)).bindTo((Object)this);
    }

    @Override
    protected MessageSink newRawMessageSink(CoreSession session, MethodHandle rawMethodHandle) {
        return new StringMessageSink(session, rawMethodHandle);
    }

    public void onWholeMessage(String wholeMessage) {
        if (!((Decoder.Text)this.getDecoder()).willDecode(wholeMessage)) {
            this.logger.warn("Message lost, decoder " + ((Decoder.Text)this.getDecoder()).getClass().getName() + "#willDecode() has rejected it.");
            return;
        }
        try {
            Object obj = ((Decoder.Text)this.getDecoder()).decode(wholeMessage);
            this.methodHandle.invoke(obj);
        }
        catch (DecodeException e) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Unable to decode", (Throwable)e);
        }
        catch (Throwable t) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Endpoint notification error", t);
        }
    }
}

