/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.common.messages;

import jakarta.websocket.Decoder;
import java.lang.invoke.MethodHandle;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.util.messages.AbstractMessageSink;
import org.eclipse.jetty.websocket.util.messages.MessageSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DecodedMessageSink<T extends Decoder>
extends AbstractMessageSink {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final T decoder;
    private final MethodHandle rawMethodHandle;
    private final MessageSink rawMessageSink;

    public DecodedMessageSink(CoreSession session, T decoder, MethodHandle methodHandle) throws NoSuchMethodException, IllegalAccessException {
        super(session, methodHandle);
        this.decoder = decoder;
        this.rawMethodHandle = this.newRawMethodHandle();
        this.rawMessageSink = this.newRawMessageSink(session, this.rawMethodHandle);
    }

    protected abstract MethodHandle newRawMethodHandle() throws NoSuchMethodException, IllegalAccessException;

    protected abstract MessageSink newRawMessageSink(CoreSession var1, MethodHandle var2);

    public T getDecoder() {
        return this.decoder;
    }

    public void accept(Frame frame, Callback callback) {
        this.rawMessageSink.accept(frame, callback);
    }
}

