/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.common.messages;

import jakarta.websocket.CloseReason;
import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketFrameHandlerFactory;
import org.eclipse.jetty.websocket.jakarta.common.messages.DecodedMessageSink;
import org.eclipse.jetty.websocket.util.messages.InputStreamMessageSink;
import org.eclipse.jetty.websocket.util.messages.MessageSink;

public class DecodedBinaryStreamMessageSink<T>
extends DecodedMessageSink<Decoder.BinaryStream<T>> {
    public DecodedBinaryStreamMessageSink(CoreSession session, Decoder.BinaryStream<T> decoder, MethodHandle methodHandle) throws NoSuchMethodException, IllegalAccessException {
        super(session, decoder, methodHandle);
    }

    @Override
    protected MethodHandle newRawMethodHandle() throws NoSuchMethodException, IllegalAccessException {
        return JakartaWebSocketFrameHandlerFactory.getServerMethodHandleLookup().findVirtual(DecodedBinaryStreamMessageSink.class, "onStreamStart", MethodType.methodType(Void.TYPE, InputStream.class)).bindTo((Object)this);
    }

    @Override
    protected MessageSink newRawMessageSink(CoreSession session, MethodHandle rawMethodHandle) {
        return new InputStreamMessageSink(session, rawMethodHandle);
    }

    public void onStreamStart(InputStream stream) {
        try {
            Object obj = ((Decoder.BinaryStream)this.getDecoder()).decode(stream);
            this.methodHandle.invoke(obj);
        }
        catch (DecodeException e) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Unable to decode", (Throwable)e);
        }
        catch (Throwable t) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Endpoint notification error", t);
        }
    }
}

