/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.common.decoders;

import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import jakarta.websocket.PongMessage;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.jakarta.common.decoders.AbstractDecoder;

public class PongMessageDecoder
extends AbstractDecoder
implements Decoder.Binary<PongMessage> {
    public PongMessage decode(ByteBuffer bytes) throws DecodeException {
        return new PongMsg(bytes);
    }

    public boolean willDecode(ByteBuffer bytes) {
        return true;
    }

    private static class PongMsg
    implements PongMessage {
        private final ByteBuffer bytes;

        public PongMsg(ByteBuffer buf) {
            int len = buf.remaining();
            this.bytes = ByteBuffer.allocate(len);
            BufferUtil.put((ByteBuffer)buf, (ByteBuffer)this.bytes);
            BufferUtil.flipToFlush((ByteBuffer)this.bytes, (int)0);
        }

        public ByteBuffer getApplicationData() {
            return this.bytes;
        }
    }
}

