/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.common.decoders;

import jakarta.websocket.Decoder;
import jakarta.websocket.EndpointConfig;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jetty.websocket.jakarta.common.InitException;
import org.eclipse.jetty.websocket.jakarta.common.decoders.BooleanDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.ByteArrayDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.ByteBufferDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.ByteDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.CharacterDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.DoubleDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.FloatDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.InputStreamDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.IntegerDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.LongDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.ReaderDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.ShortDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.StringDecoder;
import org.eclipse.jetty.websocket.util.InvalidSignatureException;
import org.eclipse.jetty.websocket.util.InvalidWebSocketException;
import org.eclipse.jetty.websocket.util.ReflectUtils;

public class AvailableDecoders
implements Iterable<RegisteredDecoder> {
    private final EndpointConfig config;
    private LinkedList<RegisteredDecoder> registeredDecoders;

    public AvailableDecoders(EndpointConfig config) {
        Objects.requireNonNull(config);
        this.config = config;
        this.registeredDecoders = new LinkedList();
        this.registerPrimitive(BooleanDecoder.class, Decoder.Text.class, Boolean.class);
        this.registerPrimitive(ByteDecoder.class, Decoder.Text.class, Byte.class);
        this.registerPrimitive(CharacterDecoder.class, Decoder.Text.class, Character.class);
        this.registerPrimitive(DoubleDecoder.class, Decoder.Text.class, Double.class);
        this.registerPrimitive(FloatDecoder.class, Decoder.Text.class, Float.class);
        this.registerPrimitive(ShortDecoder.class, Decoder.Text.class, Short.class);
        this.registerPrimitive(IntegerDecoder.class, Decoder.Text.class, Integer.class);
        this.registerPrimitive(LongDecoder.class, Decoder.Text.class, Long.class);
        this.registerPrimitive(StringDecoder.class, Decoder.Text.class, String.class);
        this.registerPrimitive(BooleanDecoder.class, Decoder.Text.class, Boolean.TYPE);
        this.registerPrimitive(ByteDecoder.class, Decoder.Text.class, Byte.TYPE);
        this.registerPrimitive(CharacterDecoder.class, Decoder.Text.class, Character.TYPE);
        this.registerPrimitive(DoubleDecoder.class, Decoder.Text.class, Double.TYPE);
        this.registerPrimitive(FloatDecoder.class, Decoder.Text.class, Float.TYPE);
        this.registerPrimitive(ShortDecoder.class, Decoder.Text.class, Short.TYPE);
        this.registerPrimitive(IntegerDecoder.class, Decoder.Text.class, Integer.TYPE);
        this.registerPrimitive(LongDecoder.class, Decoder.Text.class, Long.TYPE);
        this.registerPrimitive(ByteBufferDecoder.class, Decoder.Binary.class, ByteBuffer.class);
        this.registerPrimitive(ByteArrayDecoder.class, Decoder.Binary.class, byte[].class);
        this.registerPrimitive(ReaderDecoder.class, Decoder.TextStream.class, Reader.class);
        this.registerPrimitive(InputStreamDecoder.class, Decoder.BinaryStream.class, InputStream.class);
        this.registerAll(config.getDecoders());
    }

    private void registerPrimitive(Class<? extends Decoder> decoderClass, Class<? extends Decoder> interfaceType, Class<?> type) {
        this.registeredDecoders.add(new RegisteredDecoder(decoderClass, interfaceType, type, true));
    }

    public void register(Class<? extends Decoder> decoder) {
        if (!ReflectUtils.isDefaultConstructable(decoder)) {
            throw new InvalidSignatureException("Decoder must have public, no-args constructor: " + decoder.getName());
        }
        boolean foundDecoder = false;
        if (Decoder.Binary.class.isAssignableFrom(decoder)) {
            this.add(decoder, Decoder.Binary.class);
            foundDecoder = true;
        }
        if (Decoder.BinaryStream.class.isAssignableFrom(decoder)) {
            this.add(decoder, Decoder.BinaryStream.class);
            foundDecoder = true;
        }
        if (Decoder.Text.class.isAssignableFrom(decoder)) {
            this.add(decoder, Decoder.Text.class);
            foundDecoder = true;
        }
        if (Decoder.TextStream.class.isAssignableFrom(decoder)) {
            this.add(decoder, Decoder.TextStream.class);
            foundDecoder = true;
        }
        if (!foundDecoder) {
            throw new InvalidSignatureException("Not a valid Decoder class: " + decoder.getName() + " implements no " + Decoder.class.getName() + " interfaces");
        }
    }

    public void registerAll(Class<? extends Decoder>[] decoders) {
        if (decoders == null) {
            return;
        }
        for (Class<? extends Decoder> decoder : decoders) {
            this.register(decoder);
        }
    }

    public void registerAll(List<Class<? extends Decoder>> decoders) {
        if (decoders == null) {
            return;
        }
        decoders.forEach(this::register);
    }

    private void add(Class<? extends Decoder> decoder, Class<? extends Decoder> interfaceClass) {
        Class objectType = ReflectUtils.findGenericClassFor(decoder, interfaceClass);
        if (objectType == null) {
            StringBuilder err = new StringBuilder();
            err.append("Unknown Decoder Object type declared for interface ");
            err.append(interfaceClass.getName());
            err.append(" on class ");
            err.append(decoder);
            throw new InvalidWebSocketException(err.toString());
        }
        try {
            RegisteredDecoder conflicts = this.registeredDecoders.stream().filter(registered -> registered.isType(objectType)).filter(registered -> !registered.primitive).findFirst().get();
            if (conflicts.decoder.equals(decoder) && conflicts.implementsInterface(interfaceClass)) {
                return;
            }
            StringBuilder err = new StringBuilder();
            err.append("Duplicate Decoder Object type ");
            err.append(objectType.getName());
            err.append(" in ");
            err.append(decoder.getName());
            err.append(", previously declared in ");
            err.append(conflicts.decoder.getName());
            throw new InvalidWebSocketException(err.toString());
        }
        catch (NoSuchElementException e) {
            this.registeredDecoders.addFirst(new RegisteredDecoder(decoder, interfaceClass, objectType));
            return;
        }
    }

    public List<RegisteredDecoder> supporting(Class<? extends Decoder> interfaceType) {
        return this.registeredDecoders.stream().filter(registered -> registered.implementsInterface(interfaceType)).collect(Collectors.toList());
    }

    public RegisteredDecoder getRegisteredDecoderFor(Class<?> type) {
        return this.registeredDecoders.stream().filter(registered -> registered.isType(type)).findFirst().orElse(null);
    }

    public Class<? extends Decoder> getDecoderFor(Class<?> type) {
        try {
            return this.getRegisteredDecoderFor(type).decoder;
        }
        catch (NoSuchElementException e) {
            throw new InvalidWebSocketException("No Decoder found for type " + type);
        }
    }

    public <T extends Decoder> T getInstanceOf(RegisteredDecoder registeredDecoder) {
        if (registeredDecoder.instance != null) {
            return (T)registeredDecoder.instance;
        }
        try {
            registeredDecoder.instance = registeredDecoder.decoder.getConstructor(new Class[0]).newInstance(new Object[0]);
            registeredDecoder.instance.init(this.config);
            return (T)registeredDecoder.instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new InitException("Unable to init Decoder for type:" + registeredDecoder.decoder.getName(), e);
        }
    }

    public <T extends Decoder> T getInstanceFor(Class<?> type) {
        try {
            RegisteredDecoder registeredDecoder = this.getRegisteredDecoderFor(type);
            return this.getInstanceOf(registeredDecoder);
        }
        catch (NoSuchElementException e) {
            throw new InvalidWebSocketException("No Decoder found for type " + type);
        }
    }

    @Override
    public Iterator<RegisteredDecoder> iterator() {
        return this.registeredDecoders.iterator();
    }

    public static class RegisteredDecoder {
        public final Class<? extends Decoder> decoder;
        public final Class<? extends Decoder> interfaceType;
        public final Class<?> objectType;
        public final boolean primitive;
        public Decoder instance;

        public RegisteredDecoder(Class<? extends Decoder> decoder, Class<? extends Decoder> interfaceType, Class<?> objectType) {
            this(decoder, interfaceType, objectType, false);
        }

        public RegisteredDecoder(Class<? extends Decoder> decoder, Class<? extends Decoder> interfaceType, Class<?> objectType, boolean primitive) {
            this.decoder = decoder;
            this.interfaceType = interfaceType;
            this.objectType = objectType;
            this.primitive = primitive;
        }

        public boolean implementsInterface(Class<? extends Decoder> type) {
            return this.interfaceType.isAssignableFrom(type);
        }

        public boolean isType(Class<?> type) {
            return this.objectType.isAssignableFrom(type);
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append(RegisteredDecoder.class.getSimpleName());
            str.append('[').append(this.decoder.getName());
            str.append(',').append(this.interfaceType.getName());
            str.append(',').append(this.objectType.getName());
            if (this.primitive) {
                str.append(",PRIMITIVE");
            }
            str.append(']');
            return str.toString();
        }
    }
}

