/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.common;

import jakarta.websocket.Decoder;
import jakarta.websocket.Encoder;
import jakarta.websocket.EndpointConfig;
import java.lang.invoke.MethodHandle;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.websocket.jakarta.common.decoders.AvailableDecoders;
import org.eclipse.jetty.websocket.jakarta.common.encoders.AvailableEncoders;
import org.eclipse.jetty.websocket.util.InvalidWebSocketException;
import org.eclipse.jetty.websocket.util.messages.MessageSink;

public class JakartaWebSocketFrameHandlerMetadata {
    private static final String[] NO_VARIABLES = new String[0];
    private final EndpointConfig endpointConfig;
    private final AvailableDecoders availableDecoders;
    private final AvailableEncoders availableEncoders;
    private MethodHandle openHandle;
    private MethodHandle closeHandle;
    private MethodHandle errorHandle;
    private MessageMetadata textMetadata;
    private MessageMetadata binaryMetadata;
    private MethodHandle pongHandle;
    private UriTemplatePathSpec uriTemplatePathSpec;

    public JakartaWebSocketFrameHandlerMetadata(EndpointConfig endpointConfig) {
        this.endpointConfig = endpointConfig;
        this.availableDecoders = new AvailableDecoders(endpointConfig);
        this.availableEncoders = new AvailableEncoders(endpointConfig);
    }

    public AvailableDecoders getAvailableDecoders() {
        return this.availableDecoders;
    }

    public AvailableEncoders getAvailableEncoders() {
        return this.availableEncoders;
    }

    public MessageMetadata getBinaryMetadata() {
        return this.binaryMetadata;
    }

    public MethodHandle getCloseHandle() {
        return this.closeHandle;
    }

    public MethodHandle getErrorHandle() {
        return this.errorHandle;
    }

    public MethodHandle getOpenHandle() {
        return this.openHandle;
    }

    public void setUriTemplatePathSpec(UriTemplatePathSpec pathSpec) {
        this.uriTemplatePathSpec = pathSpec;
    }

    public UriTemplatePathSpec getUriTemplatePathSpec() {
        return this.uriTemplatePathSpec;
    }

    public String[] getNamedTemplateVariables() {
        if (this.uriTemplatePathSpec != null) {
            return this.uriTemplatePathSpec.getVariables();
        }
        return NO_VARIABLES;
    }

    public MethodHandle getPongHandle() {
        return this.pongHandle;
    }

    public MessageMetadata getTextMetadata() {
        return this.textMetadata;
    }

    public boolean hasBinaryMetadata() {
        return this.binaryMetadata != null;
    }

    public boolean hasTextMetdata() {
        return this.textMetadata != null;
    }

    public void setBinaryMetadata(MessageMetadata metadata, Object origin) {
        this.assertNotSet(this.binaryMetadata, "BINARY Message Metadata", origin);
        this.binaryMetadata = metadata;
    }

    public void setCloseHandler(MethodHandle close, Object origin) {
        this.assertNotSet(this.closeHandle, "CLOSE Handler", origin);
        this.closeHandle = close;
    }

    public void setDecoders(Class<? extends Decoder>[] decoders) {
        this.availableDecoders.registerAll(decoders);
    }

    public void setEncoders(Class<? extends Encoder>[] encoders) {
        this.availableEncoders.registerAll(encoders);
    }

    public void setErrorHandler(MethodHandle error, Object origin) {
        this.assertNotSet(this.errorHandle, "ERROR Handler", origin);
        this.errorHandle = error;
    }

    public void setOpenHandler(MethodHandle open, Object origin) {
        this.assertNotSet(this.openHandle, "OPEN Handler", origin);
        this.openHandle = open;
    }

    public void setPongHandle(MethodHandle pong, Object origin) {
        this.assertNotSet(this.pongHandle, "PONG Handler", origin);
        this.pongHandle = pong;
    }

    public void setTextMetadata(MessageMetadata metadata, Object origin) {
        this.assertNotSet(this.textMetadata, "TEXT Messsage Metadata", origin);
        this.textMetadata = metadata;
    }

    private void assertNotSet(Object val, String role, Object origin) {
        if (val == null) {
            return;
        }
        StringBuilder err = new StringBuilder();
        err.append("Cannot replace previously assigned [");
        err.append(role);
        err.append("] at ").append(this.describeOrigin(val));
        err.append(" with ");
        err.append(this.describeOrigin(origin));
        throw new InvalidWebSocketException(err.toString());
    }

    private String describeOrigin(Object obj) {
        if (obj == null) {
            return "<undefined>";
        }
        return obj.toString();
    }

    public static class MessageMetadata {
        private static final int UNSET = -1;
        public MethodHandle handle;
        public Class<? extends MessageSink> sinkClass;
        public AvailableDecoders.RegisteredDecoder registeredDecoder;
        public int maxMessageSize = -1;

        public static MessageMetadata copyOf(MessageMetadata metadata) {
            if (metadata == null) {
                return null;
            }
            MessageMetadata copy = new MessageMetadata();
            copy.handle = metadata.handle;
            copy.sinkClass = metadata.sinkClass;
            copy.registeredDecoder = metadata.registeredDecoder;
            copy.maxMessageSize = metadata.maxMessageSize;
            return copy;
        }

        public boolean isMaxMessageSizeSet() {
            return this.maxMessageSize != -1;
        }
    }
}

