/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.common;

import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Decoder;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.PongMessage;
import jakarta.websocket.server.ServerEndpointConfig;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.CloseStatus;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.OpCode;
import org.eclipse.jetty.websocket.core.exception.ProtocolException;
import org.eclipse.jetty.websocket.core.exception.WebSocketException;
import org.eclipse.jetty.websocket.jakarta.common.ClientEndpointConfigWrapper;
import org.eclipse.jetty.websocket.jakarta.common.ConfiguredEndpoint;
import org.eclipse.jetty.websocket.jakarta.common.EndpointConfigWrapper;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketContainer;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketFrameHandlerFactory;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketFrameHandlerMetadata;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketPongMessage;
import org.eclipse.jetty.websocket.jakarta.common.JakartaWebSocketSession;
import org.eclipse.jetty.websocket.jakarta.common.PutListenerMap;
import org.eclipse.jetty.websocket.jakarta.common.RegisteredMessageHandler;
import org.eclipse.jetty.websocket.jakarta.common.ServerEndpointConfigWrapper;
import org.eclipse.jetty.websocket.jakarta.common.UpgradeRequest;
import org.eclipse.jetty.websocket.jakarta.common.decoders.AvailableDecoders;
import org.eclipse.jetty.websocket.jakarta.common.messages.DecodedBinaryMessageSink;
import org.eclipse.jetty.websocket.jakarta.common.messages.DecodedBinaryStreamMessageSink;
import org.eclipse.jetty.websocket.jakarta.common.messages.DecodedTextMessageSink;
import org.eclipse.jetty.websocket.jakarta.common.messages.DecodedTextStreamMessageSink;
import org.eclipse.jetty.websocket.util.InvokerUtils;
import org.eclipse.jetty.websocket.util.messages.MessageSink;
import org.eclipse.jetty.websocket.util.messages.PartialByteArrayMessageSink;
import org.eclipse.jetty.websocket.util.messages.PartialByteBufferMessageSink;
import org.eclipse.jetty.websocket.util.messages.PartialStringMessageSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaWebSocketFrameHandler
implements FrameHandler {
    private final Logger logger;
    private final JakartaWebSocketContainer container;
    private final Object endpointInstance;
    private final AtomicBoolean closeNotified = new AtomicBoolean();
    private MethodHandle openHandle;
    private MethodHandle closeHandle;
    private MethodHandle errorHandle;
    private JakartaWebSocketFrameHandlerMetadata.MessageMetadata textMetadata;
    private JakartaWebSocketFrameHandlerMetadata.MessageMetadata binaryMetadata;
    private MethodHandle pongHandle;
    private UpgradeRequest upgradeRequest;
    private EndpointConfig endpointConfig;
    private final Map<Byte, RegisteredMessageHandler> messageHandlerMap = new HashMap<Byte, RegisteredMessageHandler>();
    private MessageSink textSink;
    private MessageSink binarySink;
    private MessageSink activeMessageSink;
    private JakartaWebSocketSession session;
    private CoreSession coreSession;
    protected byte dataType = (byte)-1;

    public JakartaWebSocketFrameHandler(JakartaWebSocketContainer container, Object endpointInstance, MethodHandle openHandle, MethodHandle closeHandle, MethodHandle errorHandle, JakartaWebSocketFrameHandlerMetadata.MessageMetadata textMetadata, JakartaWebSocketFrameHandlerMetadata.MessageMetadata binaryMetadata, MethodHandle pongHandle, EndpointConfig endpointConfig) {
        this.logger = LoggerFactory.getLogger(endpointInstance.getClass());
        this.container = container;
        if (endpointInstance instanceof ConfiguredEndpoint) {
            RuntimeException oops = new RuntimeException("ConfiguredEndpoint needs to be unwrapped");
            this.logger.warn("Unexpected ConfiguredEndpoint", (Throwable)oops);
            throw oops;
        }
        this.endpointInstance = endpointInstance;
        this.openHandle = openHandle;
        this.closeHandle = closeHandle;
        this.errorHandle = errorHandle;
        this.textMetadata = textMetadata;
        this.binaryMetadata = binaryMetadata;
        this.pongHandle = pongHandle;
        this.endpointConfig = endpointConfig;
    }

    public Object getEndpoint() {
        return this.endpointInstance;
    }

    public EndpointConfig getEndpointConfig() {
        return this.endpointConfig;
    }

    public JakartaWebSocketSession getSession() {
        return this.session;
    }

    public void onOpen(CoreSession coreSession, Callback callback) {
        this.coreSession = coreSession;
        try {
            JakartaWebSocketFrameHandlerMetadata.MessageMetadata actualBinaryMetadata;
            this.endpointConfig = this.getWrappedEndpointConfig();
            this.session = new JakartaWebSocketSession(this.container, coreSession, this, this.endpointConfig);
            this.openHandle = InvokerUtils.bindTo((MethodHandle)this.openHandle, (Object[])new Object[]{this.session, this.endpointConfig});
            this.closeHandle = InvokerUtils.bindTo((MethodHandle)this.closeHandle, (Object[])new Object[]{this.session});
            this.errorHandle = InvokerUtils.bindTo((MethodHandle)this.errorHandle, (Object[])new Object[]{this.session});
            this.pongHandle = InvokerUtils.bindTo((MethodHandle)this.pongHandle, (Object[])new Object[]{this.session});
            JakartaWebSocketFrameHandlerMetadata.MessageMetadata actualTextMetadata = JakartaWebSocketFrameHandlerMetadata.MessageMetadata.copyOf(this.textMetadata);
            if (actualTextMetadata != null) {
                if (actualTextMetadata.isMaxMessageSizeSet()) {
                    this.session.setMaxTextMessageBufferSize(actualTextMetadata.maxMessageSize);
                }
                actualTextMetadata.handle = InvokerUtils.bindTo((MethodHandle)actualTextMetadata.handle, (Object[])new Object[]{this.endpointInstance, this.endpointConfig, this.session});
                actualTextMetadata.handle = JakartaWebSocketFrameHandlerFactory.wrapNonVoidReturnType(actualTextMetadata.handle, this.session);
                this.textSink = JakartaWebSocketFrameHandlerFactory.createMessageSink(this.session, actualTextMetadata);
                this.textMetadata = actualTextMetadata;
            }
            if ((actualBinaryMetadata = JakartaWebSocketFrameHandlerMetadata.MessageMetadata.copyOf(this.binaryMetadata)) != null) {
                if (actualBinaryMetadata.isMaxMessageSizeSet()) {
                    this.session.setMaxBinaryMessageBufferSize(actualBinaryMetadata.maxMessageSize);
                }
                actualBinaryMetadata.handle = InvokerUtils.bindTo((MethodHandle)actualBinaryMetadata.handle, (Object[])new Object[]{this.endpointInstance, this.endpointConfig, this.session});
                actualBinaryMetadata.handle = JakartaWebSocketFrameHandlerFactory.wrapNonVoidReturnType(actualBinaryMetadata.handle, this.session);
                this.binarySink = JakartaWebSocketFrameHandlerFactory.createMessageSink(this.session, actualBinaryMetadata);
                this.binaryMetadata = actualBinaryMetadata;
            }
            if (this.openHandle != null) {
                this.openHandle.invoke();
            }
            this.container.notifySessionListeners(listener -> listener.onJakartaWebSocketSessionOpened(this.session));
            callback.succeeded();
        }
        catch (Throwable cause) {
            WebSocketException wse = new WebSocketException(this.endpointInstance.getClass().getSimpleName() + " OPEN method error: " + cause.getMessage(), cause);
            callback.failed((Throwable)wse);
        }
    }

    private EndpointConfig getWrappedEndpointConfig() {
        final PutListenerMap listenerMap = new PutListenerMap(this.endpointConfig.getUserProperties(), this::configListener);
        EndpointConfigWrapper wrappedConfig = this.endpointConfig instanceof ServerEndpointConfig ? new ServerEndpointConfigWrapper((ServerEndpointConfig)this.endpointConfig){

            @Override
            public Map<String, Object> getUserProperties() {
                return listenerMap;
            }
        } : (this.endpointConfig instanceof ClientEndpointConfig ? new ClientEndpointConfigWrapper((ClientEndpointConfig)this.endpointConfig){

            @Override
            public Map<String, Object> getUserProperties() {
                return listenerMap;
            }
        } : new EndpointConfigWrapper(this.endpointConfig){

            @Override
            public Map<String, Object> getUserProperties() {
                return listenerMap;
            }
        });
        return wrappedConfig;
    }

    public void onFrame(Frame frame, Callback callback) {
        switch (frame.getOpCode()) {
            case 1: {
                this.dataType = 1;
                this.onText(frame, callback);
                break;
            }
            case 2: {
                this.dataType = (byte)2;
                this.onBinary(frame, callback);
                break;
            }
            case 0: {
                this.onContinuation(frame, callback);
                break;
            }
            case 9: {
                this.onPing(frame, callback);
                break;
            }
            case 10: {
                this.onPong(frame, callback);
                break;
            }
            case 8: {
                this.onClose(frame, callback);
                break;
            }
            default: {
                callback.failed((Throwable)new IllegalStateException());
            }
        }
        if (frame.isFin() && !frame.isControlFrame()) {
            this.dataType = (byte)-1;
        }
    }

    public void onClose(Frame frame, Callback callback) {
        this.notifyOnClose(CloseStatus.getCloseStatus((Frame)frame), callback);
    }

    public void onClosed(CloseStatus closeStatus, Callback callback) {
        this.notifyOnClose(closeStatus, callback);
        this.container.notifySessionListeners(listener -> listener.onJakartaWebSocketSessionClosed(this.session));
    }

    private void notifyOnClose(CloseStatus closeStatus, Callback callback) {
        if (!this.closeNotified.compareAndSet(false, true)) {
            callback.succeeded();
            return;
        }
        try {
            if (this.closeHandle != null) {
                CloseReason closeReason = new CloseReason(CloseReason.CloseCodes.getCloseCode((int)closeStatus.getCode()), closeStatus.getReason());
                this.closeHandle.invoke(closeReason);
            }
            callback.succeeded();
        }
        catch (Throwable cause) {
            callback.failed((Throwable)new WebSocketException(this.endpointInstance.getClass().getSimpleName() + " CLOSE method error: " + cause.getMessage(), cause));
        }
    }

    public void onError(Throwable cause, Callback callback) {
        try {
            if (this.errorHandle != null) {
                this.errorHandle.invoke(cause);
            } else {
                this.logger.warn("Unhandled Error: " + this.endpointInstance, cause);
            }
            callback.succeeded();
        }
        catch (Throwable t) {
            WebSocketException wsError = new WebSocketException(this.endpointInstance.getClass().getSimpleName() + " ERROR method error: " + cause.getMessage(), t);
            wsError.addSuppressed(cause);
            callback.failed((Throwable)wsError);
        }
    }

    public Set<MessageHandler> getMessageHandlers() {
        return this.messageHandlerMap.values().stream().map(RegisteredMessageHandler::getMessageHandler).collect(Collectors.toUnmodifiableSet());
    }

    public Map<Byte, RegisteredMessageHandler> getMessageHandlerMap() {
        return this.messageHandlerMap;
    }

    public JakartaWebSocketFrameHandlerMetadata.MessageMetadata getBinaryMetadata() {
        return this.binaryMetadata;
    }

    public JakartaWebSocketFrameHandlerMetadata.MessageMetadata getTextMetadata() {
        return this.textMetadata;
    }

    private void assertBasicTypeNotRegistered(byte basicWebSocketType, Object messageImpl, String replacement) {
        if (messageImpl != null) {
            throw new IllegalStateException("Cannot register " + replacement + ": Basic WebSocket type " + OpCode.name((byte)basicWebSocketType) + " is already registered");
        }
    }

    public <T> void addMessageHandler(JakartaWebSocketSession session, Class<T> clazz, MessageHandler.Partial<T> handler) {
        block6: {
            try {
                MethodHandles.Lookup lookup = JakartaWebSocketFrameHandlerFactory.getServerMethodHandleLookup();
                MethodHandle partialMessageHandler = lookup.findVirtual(MessageHandler.Partial.class, "onMessage", MethodType.methodType(Void.TYPE, Object.class, Boolean.TYPE));
                partialMessageHandler = partialMessageHandler.bindTo(handler);
                if (byte[].class.isAssignableFrom(clazz)) {
                    this.assertBasicTypeNotRegistered((byte)2, this.binaryMetadata, handler.getClass().getName());
                    PartialByteArrayMessageSink messageSink = new PartialByteArrayMessageSink(this.coreSession, partialMessageHandler);
                    this.binarySink = this.registerMessageHandler((byte)2, clazz, (MessageHandler)handler, (MessageSink)messageSink);
                    JakartaWebSocketFrameHandlerMetadata.MessageMetadata metadata = new JakartaWebSocketFrameHandlerMetadata.MessageMetadata();
                    metadata.handle = partialMessageHandler;
                    metadata.sinkClass = PartialByteArrayMessageSink.class;
                    this.binaryMetadata = metadata;
                    break block6;
                }
                if (ByteBuffer.class.isAssignableFrom(clazz)) {
                    this.assertBasicTypeNotRegistered((byte)2, this.binaryMetadata, handler.getClass().getName());
                    PartialByteBufferMessageSink messageSink = new PartialByteBufferMessageSink(this.coreSession, partialMessageHandler);
                    this.binarySink = this.registerMessageHandler((byte)2, clazz, (MessageHandler)handler, (MessageSink)messageSink);
                    JakartaWebSocketFrameHandlerMetadata.MessageMetadata metadata = new JakartaWebSocketFrameHandlerMetadata.MessageMetadata();
                    metadata.handle = partialMessageHandler;
                    metadata.sinkClass = PartialByteBufferMessageSink.class;
                    this.binaryMetadata = metadata;
                    break block6;
                }
                if (String.class.isAssignableFrom(clazz)) {
                    this.assertBasicTypeNotRegistered((byte)1, this.textMetadata, handler.getClass().getName());
                    PartialStringMessageSink messageSink = new PartialStringMessageSink(this.coreSession, partialMessageHandler);
                    this.textSink = this.registerMessageHandler((byte)1, clazz, (MessageHandler)handler, (MessageSink)messageSink);
                    JakartaWebSocketFrameHandlerMetadata.MessageMetadata metadata = new JakartaWebSocketFrameHandlerMetadata.MessageMetadata();
                    metadata.handle = partialMessageHandler;
                    metadata.sinkClass = PartialStringMessageSink.class;
                    this.textMetadata = metadata;
                    break block6;
                }
                throw new RuntimeException("Unable to add " + handler.getClass().getName() + " with type " + clazz + ": only supported types byte[], " + ByteBuffer.class.getName() + ", " + String.class.getName());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Unable to find method", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to access " + handler.getClass().getName(), e);
            }
        }
    }

    public <T> void addMessageHandler(JakartaWebSocketSession session, Class<T> clazz, MessageHandler.Whole<T> handler) {
        block9: {
            try {
                MethodHandles.Lookup lookup = JakartaWebSocketFrameHandlerFactory.getServerMethodHandleLookup();
                MethodHandle wholeMsgMethodHandle = lookup.findVirtual(MessageHandler.Whole.class, "onMessage", MethodType.methodType(Void.TYPE, Object.class));
                wholeMsgMethodHandle = wholeMsgMethodHandle.bindTo(handler);
                if (PongMessage.class.isAssignableFrom(clazz)) {
                    this.assertBasicTypeNotRegistered((byte)10, this.pongHandle, handler.getClass().getName());
                    this.pongHandle = wholeMsgMethodHandle;
                    this.registerMessageHandler((byte)10, clazz, (MessageHandler)handler, null);
                    break block9;
                }
                AvailableDecoders availableDecoders = session.getDecoders();
                AvailableDecoders.RegisteredDecoder registeredDecoder = availableDecoders.getRegisteredDecoderFor(clazz);
                if (registeredDecoder == null) {
                    throw new IllegalStateException("Unable to find Decoder for type: " + clazz);
                }
                JakartaWebSocketFrameHandlerMetadata.MessageMetadata metadata = new JakartaWebSocketFrameHandlerMetadata.MessageMetadata();
                metadata.handle = wholeMsgMethodHandle;
                metadata.registeredDecoder = registeredDecoder;
                if (registeredDecoder.implementsInterface(Decoder.Binary.class)) {
                    this.assertBasicTypeNotRegistered((byte)2, this.binaryMetadata, handler.getClass().getName());
                    Decoder.Binary decoder = (Decoder.Binary)availableDecoders.getInstanceOf(registeredDecoder);
                    DecodedBinaryMessageSink messageSink = new DecodedBinaryMessageSink(this.coreSession, decoder, wholeMsgMethodHandle);
                    metadata.sinkClass = ((Object)((Object)messageSink)).getClass();
                    this.binarySink = this.registerMessageHandler((byte)2, clazz, (MessageHandler)handler, (MessageSink)messageSink);
                    this.binaryMetadata = metadata;
                    break block9;
                }
                if (registeredDecoder.implementsInterface(Decoder.BinaryStream.class)) {
                    this.assertBasicTypeNotRegistered((byte)2, this.binaryMetadata, handler.getClass().getName());
                    Decoder.BinaryStream decoder = (Decoder.BinaryStream)availableDecoders.getInstanceOf(registeredDecoder);
                    DecodedBinaryStreamMessageSink messageSink = new DecodedBinaryStreamMessageSink(this.coreSession, decoder, wholeMsgMethodHandle);
                    metadata.sinkClass = ((Object)((Object)messageSink)).getClass();
                    this.binarySink = this.registerMessageHandler((byte)2, clazz, (MessageHandler)handler, (MessageSink)messageSink);
                    this.binaryMetadata = metadata;
                    break block9;
                }
                if (registeredDecoder.implementsInterface(Decoder.Text.class)) {
                    this.assertBasicTypeNotRegistered((byte)1, this.textMetadata, handler.getClass().getName());
                    Decoder.Text decoder = (Decoder.Text)availableDecoders.getInstanceOf(registeredDecoder);
                    DecodedTextMessageSink messageSink = new DecodedTextMessageSink(this.coreSession, decoder, wholeMsgMethodHandle);
                    metadata.sinkClass = ((Object)((Object)messageSink)).getClass();
                    this.textSink = this.registerMessageHandler((byte)1, clazz, (MessageHandler)handler, (MessageSink)messageSink);
                    this.textMetadata = metadata;
                    break block9;
                }
                if (registeredDecoder.implementsInterface(Decoder.TextStream.class)) {
                    this.assertBasicTypeNotRegistered((byte)1, this.textMetadata, handler.getClass().getName());
                    Decoder.TextStream decoder = (Decoder.TextStream)availableDecoders.getInstanceOf(registeredDecoder);
                    DecodedTextStreamMessageSink messageSink = new DecodedTextStreamMessageSink(this.coreSession, decoder, wholeMsgMethodHandle);
                    metadata.sinkClass = ((Object)((Object)messageSink)).getClass();
                    this.textSink = this.registerMessageHandler((byte)1, clazz, (MessageHandler)handler, (MessageSink)messageSink);
                    this.textMetadata = metadata;
                    break block9;
                }
                throw new RuntimeException("Unable to add " + handler.getClass().getName() + ": type " + clazz + " is unrecognized by declared decoders");
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Unable to find method", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to access " + handler.getClass().getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> MessageSink registerMessageHandler(byte basicWebSocketMessageType, Class<T> handlerType, MessageHandler handler, MessageSink messageSink) {
        Map<Byte, RegisteredMessageHandler> map = this.messageHandlerMap;
        synchronized (map) {
            RegisteredMessageHandler registeredHandler = this.messageHandlerMap.get(basicWebSocketMessageType);
            if (registeredHandler != null) {
                throw new IllegalStateException(String.format("Cannot register %s: Basic WebSocket type %s is already registered to %s", handler.getClass().getName(), OpCode.name((byte)basicWebSocketMessageType), registeredHandler.getMessageHandler().getClass().getName()));
            }
            registeredHandler = new RegisteredMessageHandler(basicWebSocketMessageType, handlerType, handler);
            this.getMessageHandlerMap().put(registeredHandler.getWebsocketMessageType(), registeredHandler);
            return messageSink;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(MessageHandler handler) {
        Map<Byte, RegisteredMessageHandler> map = this.messageHandlerMap;
        synchronized (map) {
            Optional<Map.Entry> optionalEntry = this.messageHandlerMap.entrySet().stream().filter(entry -> ((RegisteredMessageHandler)entry.getValue()).getMessageHandler().equals(handler)).findFirst();
            if (optionalEntry.isPresent()) {
                byte key = (Byte)optionalEntry.get().getKey();
                this.messageHandlerMap.remove(key);
                switch (key) {
                    case 10: {
                        this.pongHandle = null;
                        break;
                    }
                    case 1: {
                        this.textMetadata = null;
                        this.textSink = null;
                        break;
                    }
                    case 2: {
                        this.binaryMetadata = null;
                        this.binarySink = null;
                        break;
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getClass().getSimpleName());
        ret.append('@').append(Integer.toHexString(this.hashCode()));
        ret.append("[endpoint=");
        if (this.endpointInstance == null) {
            ret.append("<null>");
        } else {
            ret.append(this.endpointInstance.getClass().getName());
        }
        ret.append(']');
        return ret.toString();
    }

    private void acceptMessage(Frame frame, Callback callback) {
        if (this.activeMessageSink == null) {
            callback.succeeded();
            return;
        }
        this.activeMessageSink.accept(frame, callback);
        if (frame.isFin()) {
            this.activeMessageSink = null;
        }
    }

    public void onPing(Frame frame, Callback callback) {
        ByteBuffer payload = BufferUtil.copy((ByteBuffer)frame.getPayload());
        this.coreSession.sendFrame(new Frame(10).setPayload(payload), Callback.NOOP, false);
        callback.succeeded();
    }

    public void onPong(Frame frame, Callback callback) {
        if (this.pongHandle != null) {
            try {
                ByteBuffer payload = frame.getPayload();
                if (payload == null) {
                    payload = BufferUtil.EMPTY_BUFFER;
                }
                JakartaWebSocketPongMessage pongMessage = new JakartaWebSocketPongMessage(payload);
                this.pongHandle.invoke(pongMessage);
            }
            catch (Throwable cause) {
                throw new WebSocketException(this.endpointInstance.getClass().getSimpleName() + " PONG method error: " + cause.getMessage(), cause);
            }
        }
        callback.succeeded();
    }

    public void onText(Frame frame, Callback callback) {
        if (this.activeMessageSink == null) {
            this.activeMessageSink = this.textSink;
        }
        this.acceptMessage(frame, callback);
    }

    public void onBinary(Frame frame, Callback callback) {
        if (this.activeMessageSink == null) {
            this.activeMessageSink = this.binarySink;
        }
        this.acceptMessage(frame, callback);
    }

    public void onContinuation(Frame frame, Callback callback) {
        switch (this.dataType) {
            case 1: {
                this.onText(frame, callback);
                break;
            }
            case 2: {
                this.onBinary(frame, callback);
                break;
            }
            default: {
                throw new ProtocolException("Unable to process continuation during dataType " + this.dataType);
            }
        }
    }

    public void setUpgradeRequest(UpgradeRequest upgradeRequest) {
        this.upgradeRequest = upgradeRequest;
    }

    public UpgradeRequest getUpgradeRequest() {
        return this.upgradeRequest;
    }

    private void configListener(String key, Object value) {
        if (!key.startsWith("org.eclipse.jetty.websocket.")) {
            return;
        }
        switch (key) {
            case "org.eclipse.jetty.websocket.autoFragment": {
                this.coreSession.setAutoFragment(((Boolean)value).booleanValue());
                break;
            }
            case "org.eclipse.jetty.websocket.maxFrameSize": {
                this.coreSession.setMaxFrameSize(((Long)value).longValue());
                break;
            }
            case "org.eclipse.jetty.websocket.outputBufferSize": {
                this.coreSession.setOutputBufferSize(((Integer)value).intValue());
                break;
            }
            case "org.eclipse.jetty.websocket.inputBufferSize": {
                this.coreSession.setInputBufferSize(((Integer)value).intValue());
            }
        }
    }
}

