/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventMethods;
import org.eclipse.jetty.websocket.common.message.MessageAppender;
import org.eclipse.jetty.websocket.common.message.MessageInputStream;
import org.eclipse.jetty.websocket.common.message.MessageReader;
import org.eclipse.jetty.websocket.common.message.SimpleBinaryMessage;
import org.eclipse.jetty.websocket.common.message.SimpleTextMessage;

public class AnnotatedEventDriver
extends EventDriver {
    private final EventMethods events;
    private MessageAppender activeMessage;

    public AnnotatedEventDriver(WebSocketPolicy policy, Object websocket, EventMethods events) {
        super(policy, websocket);
        this.events = events;
        WebSocket anno = websocket.getClass().getAnnotation(WebSocket.class);
        if (anno.maxBufferSize() > 0) {
            this.policy.setBufferSize(anno.maxBufferSize());
        }
        if (anno.maxBinarySize() > 0) {
            this.policy.setMaxBinaryMessageSize(anno.maxBinarySize());
        }
        if (anno.maxTextSize() > 0) {
            this.policy.setMaxTextMessageSize(anno.maxTextSize());
        }
        if (anno.maxIdleTime() > 0) {
            this.policy.setIdleTimeout(anno.maxIdleTime());
        }
    }

    @Override
    public void onBinaryFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.events.onBinary == null) {
            return;
        }
        if (this.activeMessage == null) {
            this.activeMessage = this.events.onBinary.isStreaming() ? new MessageInputStream(this) : new SimpleBinaryMessage(this);
        }
        this.activeMessage.appendMessage(buffer);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    @Override
    public void onBinaryMessage(byte[] data) {
        if (this.events.onBinary != null) {
            this.events.onBinary.call(this.websocket, new Object[]{this.session, data, 0, data.length});
        }
    }

    @Override
    public void onClose(CloseInfo close) {
        if (this.events.onClose != null) {
            this.events.onClose.call(this.websocket, new Object[]{this.session, close.getStatusCode(), close.getReason()});
        }
    }

    @Override
    public void onConnect() {
        if (this.events.onConnect != null) {
            this.events.onConnect.call(this.websocket, new Object[]{this.session});
        }
    }

    @Override
    public void onException(WebSocketException e) {
        if (this.events.onException != null) {
            this.events.onException.call(this.websocket, new Object[]{this.session, e});
        }
    }

    @Override
    public void onFrame(Frame frame) {
        if (this.events.onFrame != null) {
            this.events.onFrame.call(this.websocket, new Object[]{this.session, frame});
        }
    }

    public void onInputStream(InputStream stream) {
        if (this.events.onBinary != null) {
            this.events.onBinary.call(this.websocket, new Object[]{this.session, stream});
        }
    }

    public void onReader(Reader reader) {
        if (this.events.onText != null) {
            this.events.onText.call(this.websocket, new Object[]{this.session, reader});
        }
    }

    @Override
    public void onTextFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.events.onText == null) {
            return;
        }
        if (this.activeMessage == null) {
            this.activeMessage = this.events.onText.isStreaming() ? new MessageReader(this) : new SimpleTextMessage(this);
        }
        this.activeMessage.appendMessage(buffer);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    @Override
    public void onTextMessage(String message) {
        if (this.events.onText != null) {
            this.events.onText.call(this.websocket, new Object[]{this.session, message});
        }
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.websocket);
    }
}

