/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.io.AbstractWebSocketConnection;
import org.eclipse.jetty.websocket.common.io.FrameBytes;

public class ControlFrameBytes
extends FrameBytes {
    private static final Logger LOG = Log.getLogger(ControlFrameBytes.class);
    private ByteBuffer buffer;
    private ByteBuffer origPayload;

    public ControlFrameBytes(AbstractWebSocketConnection connection, Frame frame) {
        super(connection, frame);
    }

    @Override
    public void completed(Void context) {
        LOG.debug("completed() - frame: {}", new Object[]{this.frame});
        this.connection.getBufferPool().release(this.buffer);
        super.completed(context);
        if (this.frame.getType().getOpCode() == 8) {
            CloseInfo close = new CloseInfo(this.origPayload, false);
            this.connection.onCloseHandshake(false, close);
        }
        this.connection.flush();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        if (this.buffer == null) {
            if (this.frame.hasPayload()) {
                this.origPayload = this.frame.getPayload().slice();
            }
            this.buffer = this.connection.getGenerator().generate(this.frame);
        }
        return this.buffer;
    }
}

