/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.mux;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.websocket.SendResult;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.WebSocketConnection;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.ConnectionState;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.extensions.mux.Muxer;

public class MuxChannel
implements WebSocketConnection,
LogicalConnection,
IncomingFrames,
SuspendToken {
    private static final Logger LOG = Log.getLogger(MuxChannel.class);
    private final long channelId;
    private final Muxer muxer;
    private final AtomicBoolean inputClosed;
    private final AtomicBoolean outputClosed;
    private final AtomicBoolean suspendToken;
    private ConnectionState connectionState;
    private WebSocketPolicy policy;
    private WebSocketSession session;
    private IncomingFrames incoming;
    private String subProtocol;

    public MuxChannel(long channelId, Muxer muxer) {
        this.channelId = channelId;
        this.muxer = muxer;
        this.policy = muxer.getPolicy().clonePolicy();
        this.suspendToken = new AtomicBoolean(false);
        this.connectionState = ConnectionState.CONNECTING;
        this.inputClosed = new AtomicBoolean(false);
        this.outputClosed = new AtomicBoolean(false);
    }

    @Override
    public void assertInputOpen() throws IOException {
    }

    @Override
    public void assertOutputOpen() throws IOException {
    }

    @Override
    public void close() {
        this.close(1000, null);
    }

    @Override
    public void close(int statusCode, String reason) {
        CloseInfo close = new CloseInfo(statusCode, reason);
        try {
            this.outgoingFrame(close.asFrame());
        }
        catch (IOException e) {
            LOG.warn("Unable to issue Close", (Throwable)e);
            this.disconnect();
        }
    }

    @Override
    public void disconnect() {
        this.connectionState = ConnectionState.CLOSED;
    }

    public long getChannelId() {
        return this.channelId;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return null;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.muxer.getRemoteAddress();
    }

    public URI getRequestURI() {
        return null;
    }

    @Override
    public WebSocketSession getSession() {
        return this.session;
    }

    @Override
    public ConnectionState getState() {
        return this.connectionState;
    }

    public String getSubProtocol() {
        return this.subProtocol;
    }

    public void incomingError(WebSocketException e) {
        this.incoming.incomingError(e);
    }

    public void incomingFrame(Frame frame) {
        this.incoming.incomingFrame(frame);
    }

    public boolean isActive() {
        return this.getState() != ConnectionState.CLOSED;
    }

    @Override
    public boolean isInputClosed() {
        return this.inputClosed.get();
    }

    @Override
    public boolean isOpen() {
        return this.isActive() && this.muxer.isOpen();
    }

    @Override
    public boolean isOutputClosed() {
        return this.outputClosed.get();
    }

    @Override
    public boolean isReading() {
        return true;
    }

    public void onClose() {
        this.connectionState = ConnectionState.CLOSED;
    }

    @Override
    public void onCloseHandshake(boolean incoming, CloseInfo close) {
        boolean in = this.inputClosed.get();
        boolean out = this.outputClosed.get();
        if (incoming) {
            in = true;
            this.inputClosed.set(true);
        } else {
            out = true;
            this.outputClosed.set(true);
        }
        LOG.debug("onCloseHandshake({},{}), input={}, output={}", new Object[]{incoming, close, in, out});
        if (in && out) {
            LOG.debug("Close Handshake satisfied, disconnecting", new Object[0]);
            this.disconnect();
        }
        if (close.isHarsh()) {
            LOG.debug("Close status code was harsh, disconnecting", new Object[0]);
            this.disconnect();
        }
    }

    public void onOpen() {
        this.connectionState = ConnectionState.OPEN;
    }

    public Future<SendResult> outgoingFrame(Frame frame) throws IOException {
        return this.muxer.output(this.channelId, frame);
    }

    public void ping(ByteBuffer buf) throws IOException {
        this.outgoingFrame(WebSocketFrame.ping().setPayload(buf));
    }

    public void resume() {
        if (this.suspendToken.getAndSet(false)) {
            // empty if block
        }
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.incoming = incoming;
    }

    @Override
    public void setSession(WebSocketSession session) {
        this.session = session;
    }

    public void setSubProtocol(String subProtocol) {
        this.subProtocol = subProtocol;
    }

    @Override
    public SuspendToken suspend() {
        this.suspendToken.set(true);
        return this;
    }

    public Future<SendResult> write(byte[] buf, int offset, int len) throws IOException {
        return this.outgoingFrame(WebSocketFrame.binary().setPayload(buf, offset, len));
    }

    public Future<SendResult> write(ByteBuffer buffer) throws IOException {
        return this.outgoingFrame(WebSocketFrame.binary().setPayload(buffer));
    }

    public Future<SendResult> write(String message) throws IOException {
        return this.outgoingFrame(WebSocketFrame.text(message));
    }
}

