/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.internal.io;

import java.util.concurrent.Executor;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.client.WebSocketClientFactory;
import org.eclipse.jetty.websocket.client.internal.DefaultWebSocketClient;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.core.io.AbstractWebSocketConnection;
import org.eclipse.jetty.websocket.core.protocol.WebSocketFrame;

public class WebSocketClientConnection
extends AbstractWebSocketConnection {
    private final WebSocketClientFactory factory;
    private final DefaultWebSocketClient client;
    private final Masker masker;
    private boolean connected;

    public WebSocketClientConnection(EndPoint endp, Executor executor, DefaultWebSocketClient client) {
        super(endp, executor, client.getFactory().getScheduler(), client.getPolicy(), client.getFactory().getBufferPool());
        this.client = client;
        this.factory = client.getFactory();
        this.connected = false;
        this.masker = client.getMasker();
    }

    public DefaultWebSocketClient getClient() {
        return this.client;
    }

    public void onClose() {
        super.onClose();
        this.factory.sessionClosed(this.getSession());
    }

    public void onOpen() {
        if (!this.connected) {
            this.factory.sessionOpened(this.getSession());
            this.connected = true;
        }
        super.onOpen();
    }

    public <C> void output(C context, Callback<C> callback, WebSocketFrame frame) {
        this.masker.setMask(frame);
        super.output(context, callback, frame);
    }
}

