/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.TimerScheduler;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.internal.ConnectionManager;
import org.eclipse.jetty.websocket.client.internal.IWebSocketClient;
import org.eclipse.jetty.websocket.core.api.Extension;
import org.eclipse.jetty.websocket.core.api.ExtensionRegistry;
import org.eclipse.jetty.websocket.core.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.core.driver.EventMethodsCache;
import org.eclipse.jetty.websocket.core.driver.WebSocketEventDriver;
import org.eclipse.jetty.websocket.core.extensions.WebSocketExtensionRegistry;
import org.eclipse.jetty.websocket.core.io.WebSocketSession;
import org.eclipse.jetty.websocket.core.protocol.ExtensionConfig;

public class WebSocketClientFactory
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(WebSocketClientFactory.class);
    private final ByteBufferPool bufferPool = new MappedByteBufferPool();
    private final Executor executor;
    private final Scheduler scheduler;
    private final EventMethodsCache methodsCache;
    private final WebSocketPolicy policy;
    private final WebSocketExtensionRegistry extensionRegistry;
    private SocketAddress bindAddress;
    private final Queue<WebSocketSession> sessions = new ConcurrentLinkedQueue<WebSocketSession>();
    private ConnectionManager connectionManager;

    public WebSocketClientFactory() {
        this((Executor)new QueuedThreadPool());
    }

    public WebSocketClientFactory(Executor threadPool) {
        this(threadPool, (Scheduler)new TimerScheduler());
    }

    public WebSocketClientFactory(Executor threadPool, Scheduler scheduler) {
        this(threadPool, scheduler, null);
    }

    public WebSocketClientFactory(Executor executor, Scheduler scheduler, SslContextFactory sslContextFactory) {
        LOG.debug("new WebSocketClientFactory()", new Object[0]);
        if (executor == null) {
            throw new IllegalArgumentException("Executor is required");
        }
        this.executor = executor;
        this.addBean(executor);
        if (scheduler == null) {
            throw new IllegalArgumentException("Scheduler is required");
        }
        this.scheduler = scheduler;
        this.addBean(scheduler);
        if (sslContextFactory != null) {
            this.addBean(sslContextFactory);
        }
        this.policy = WebSocketPolicy.newClientPolicy();
        this.extensionRegistry = new WebSocketExtensionRegistry(this.policy, this.bufferPool);
        this.connectionManager = new ConnectionManager(this.bufferPool, executor, scheduler, sslContextFactory, this.policy);
        this.addBean((Object)this.connectionManager);
        this.methodsCache = new EventMethodsCache();
    }

    public WebSocketClientFactory(SslContextFactory sslContextFactory) {
        this((Executor)new QueuedThreadPool(), (Scheduler)new TimerScheduler(), sslContextFactory);
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("doStart()", new Object[0]);
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("doStop()", new Object[0]);
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extensionRegistry;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public List<Extension> initExtensions(List<ExtensionConfig> requested) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (ExtensionConfig cfg : requested) {
            Extension extension = this.extensionRegistry.newInstance(cfg);
            if (extension == null) continue;
            LOG.debug("added {}", new Object[]{extension});
            extensions.add(extension);
        }
        LOG.debug("extensions={}", new Object[]{extensions});
        return extensions;
    }

    public WebSocketClient newWebSocketClient(Object websocketPojo) {
        LOG.debug("Creating new WebSocket for {}", new Object[]{websocketPojo});
        WebSocketEventDriver websocket = new WebSocketEventDriver(websocketPojo, this.methodsCache, this.policy, this.getBufferPool());
        return new IWebSocketClient(this, websocket);
    }

    public boolean sessionClosed(WebSocketSession session) {
        return this.isRunning() && this.sessions.remove(session);
    }

    public boolean sessionOpened(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session Opened: {}", new Object[]{session});
        }
        boolean ret = this.sessions.offer(session);
        session.onConnect();
        return ret;
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }
}

