/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.websocket.HandshakeResponse;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.util.QuoteUtil;

public class UpgradeResponse
implements HandshakeResponse {
    public static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    private int statusCode;
    private String statusReason;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
    private boolean success = false;

    public void addHeader(String name, String value) {
        String key = name.toLowerCase();
        List<String> values = this.headers.get(key);
        if (values == null) {
            values = new ArrayList<String>();
        }
        values.add(value);
        this.headers.put(key, values);
    }

    public String getAcceptedSubProtocol() {
        return this.getHeader(SEC_WEBSOCKET_PROTOCOL);
    }

    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    public String getHeader(String name) {
        List<String> values = this.getHeaders(name);
        if (values == null) {
            return null;
        }
        int size = values.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            return values.get(0);
        }
        boolean needsDelim = false;
        StringBuilder ret = new StringBuilder();
        for (String value : values) {
            if (needsDelim) {
                ret.append(", ");
            }
            QuoteUtil.quoteIfNeeded(ret, value, "\"'\\\n\r\t\f\b%+ ;=");
            needsDelim = true;
        }
        return ret.toString();
    }

    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> getHeaders(String name) {
        return this.headers.get(name.toLowerCase());
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void sendForbidden(String message) throws IOException {
    }

    public void setAcceptedSubProtocol(String protocol) {
        this.setHeader(SEC_WEBSOCKET_PROTOCOL, protocol);
    }

    public void setExtensions(List<ExtensionConfig> extensions) {
        this.extensions.clear();
        if (extensions != null) {
            this.extensions.addAll(extensions);
        }
    }

    public void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.headers.put(name.toLowerCase(), values);
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }
}

