/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.MessageSink;
import org.eclipse.jetty.websocket.common.message.CallbackBuffer;
import org.eclipse.jetty.websocket.core.Frame;

public class MessageInputStream
extends InputStream
implements MessageSink {
    private static final Logger LOG = Log.getLogger(MessageInputStream.class);
    private static final CallbackBuffer EOF = new CallbackBuffer(Callback.NOOP, ByteBuffer.allocate(0).asReadOnlyBuffer());
    private final Deque<CallbackBuffer> buffers = new ArrayDeque<CallbackBuffer>(2);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private CallbackBuffer activeFrame;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Frame frame, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("accepting {}", new Object[]{frame});
        }
        if (this.closed.get()) {
            callback.failed((Throwable)new IOException("Already Closed"));
            return;
        }
        if (!frame.hasPayload() && !frame.isFin()) {
            callback.succeeded();
            return;
        }
        Deque<CallbackBuffer> deque = this.buffers;
        synchronized (deque) {
            boolean notify = false;
            if (frame.hasPayload()) {
                this.buffers.offer(new CallbackBuffer(callback, frame.getPayload()));
                notify = true;
            } else {
                callback.succeeded();
            }
            if (frame.isFin()) {
                this.buffers.offer(EOF);
                notify = true;
            }
            if (notify) {
                this.buffers.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("close()", new Object[0]);
        }
        if (this.closed.compareAndSet(false, true)) {
            Deque<CallbackBuffer> deque = this.buffers;
            synchronized (deque) {
                this.buffers.offer(EOF);
                this.buffers.notify();
            }
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallbackBuffer getActiveFrame() throws InterruptedIOException {
        if (this.activeFrame == null) {
            CallbackBuffer result;
            Deque<CallbackBuffer> deque = this.buffers;
            synchronized (deque) {
                try {
                    while ((result = this.buffers.poll()) == null) {
                        this.buffers.wait();
                    }
                }
                catch (InterruptedException e) {
                    this.shutdown();
                    throw new InterruptedIOException();
                }
            }
            this.activeFrame = result;
        }
        return this.activeFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("shutdown()", new Object[0]);
        }
        Deque<CallbackBuffer> deque = this.buffers;
        synchronized (deque) {
            this.closed.set(true);
            IOException cause = new IOException("Shutdown");
            for (CallbackBuffer buffer : this.buffers) {
                buffer.callback.failed((Throwable)cause);
            }
            this.buffers.clear();
        }
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int len;
        byte[] buf = new byte[1];
        do {
            if ((len = this.read(buf, 0, 1)) >= 0) continue;
            return -1;
        } while (len <= 0);
        return buf[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed.get()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream closed", new Object[0]);
            }
            return -1;
        }
        CallbackBuffer result = this.getActiveFrame();
        if (LOG.isDebugEnabled()) {
            LOG.debug("result = {}", new Object[]{result});
        }
        if (result == EOF) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read EOF", new Object[0]);
            }
            this.shutdown();
            return -1;
        }
        int fillLen = Math.min(result.buffer.remaining(), len);
        result.buffer.get(b, off, fillLen);
        if (!result.buffer.hasRemaining()) {
            this.activeFrame = null;
            result.callback.succeeded();
        }
        return fillLen;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }
}

