/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests.matchers;

import java.util.Map;
import javax.websocket.Decoder;
import javax.websocket.PongMessage;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketSession;
import org.eclipse.jetty.websocket.javax.common.RegisteredMessageHandler;
import org.eclipse.jetty.websocket.javax.common.decoders.AvailableDecoders;
import org.eclipse.jetty.websocket.javax.tests.MessageType;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class IsMessageHandlerTypeRegistered
extends TypeSafeMatcher<JavaxWebSocketSession> {
    private final MessageType expectedType;

    public IsMessageHandlerTypeRegistered(MessageType expectedType) {
        this.expectedType = expectedType;
    }

    public void describeTo(Description description) {
        description.appendText(".getMessageHandlers() contains registered MessageHandler for type " + this.expectedType);
    }

    protected boolean matchesSafely(JavaxWebSocketSession session) {
        Map handlerMap = session.getFrameHandler().getMessageHandlerMap();
        if (handlerMap == null) {
            return false;
        }
        for (RegisteredMessageHandler registeredMessageHandler : handlerMap.values()) {
            Class onMessageType = registeredMessageHandler.getHandlerType();
            AvailableDecoders.RegisteredDecoder registeredDecoder = session.getDecoders().getRegisteredDecoderFor(onMessageType);
            if (registeredDecoder == null) continue;
            if (this.expectedType == MessageType.PONG) {
                if (!PongMessage.class.isAssignableFrom(registeredDecoder.objectType)) continue;
                return true;
            }
            if (this.expectedType == MessageType.BINARY) {
                if (registeredDecoder.implementsInterface(Decoder.Binary.class)) {
                    return true;
                }
                if (!registeredDecoder.implementsInterface(Decoder.BinaryStream.class)) continue;
                return true;
            }
            if (this.expectedType != MessageType.TEXT) continue;
            if (registeredDecoder.implementsInterface(Decoder.Text.class)) {
                return true;
            }
            if (!registeredDecoder.implementsInterface(Decoder.TextStream.class)) continue;
            return true;
        }
        return false;
    }

    protected void describeMismatchSafely(JavaxWebSocketSession session, Description mismatchDescription) {
        Map handlerMap = session.getFrameHandler().getMessageHandlerMap();
        mismatchDescription.appendText(".getMessageHandlers()");
        if (handlerMap == null) {
            mismatchDescription.appendText(" is <null>");
            return;
        }
        mismatchDescription.appendText(" contains [");
        boolean delim = false;
        for (RegisteredMessageHandler registeredMessageHandler : handlerMap.values()) {
            Class<?> handlerClass = registeredMessageHandler.getMessageHandler().getClass();
            if (delim) {
                mismatchDescription.appendText(", ");
            }
            delim = true;
            mismatchDescription.appendText(handlerClass.getName());
            Class onMessageType = registeredMessageHandler.getHandlerType();
            if (onMessageType == null) {
                mismatchDescription.appendText("<UnknownType>");
                continue;
            }
            mismatchDescription.appendText("<" + onMessageType.getName() + ">");
            AvailableDecoders.RegisteredDecoder registeredDecoder = session.getDecoders().getRegisteredDecoderFor(onMessageType);
            if (registeredDecoder == null) {
                mismatchDescription.appendText("(!NO-DECODER!)");
                continue;
            }
            mismatchDescription.appendText("(" + registeredDecoder.interfaceType.getName() + ")");
        }
        mismatchDescription.appendText("]");
    }

    public static IsMessageHandlerTypeRegistered isMessageHandlerTypeRegistered(MessageType messageType) {
        return new IsMessageHandlerTypeRegistered(messageType);
    }
}

