/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.tests.framehandlers;

import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.CloseStatus;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.FrameHandler;

public class FrameEcho
implements FrameHandler {
    private static final Logger LOG = Log.getLogger(FrameEcho.class);
    private FrameHandler.CoreSession coreSession;

    public void onOpen(FrameHandler.CoreSession coreSession, Callback callback) {
        this.coreSession = coreSession;
        callback.succeeded();
    }

    public void onFrame(Frame frame, Callback callback) {
        if (frame.isControlFrame()) {
            callback.succeeded();
        } else {
            this.coreSession.sendFrame(Frame.copy((Frame)frame), callback, false);
        }
    }

    public void onError(Throwable cause, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this + " onError ", cause);
        }
        callback.succeeded();
    }

    public void onClosed(CloseStatus closeStatus, Callback callback) {
        this.coreSession = null;
        callback.succeeded();
    }
}

